/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.patchwork.impl;

import de.siphalor.tweed5.patchwork.api.InvalidPatchworkAccessException;
import de.siphalor.tweed5.patchwork.api.Patchwork;
import de.siphalor.tweed5.patchwork.api.PatchworkFactory;
import de.siphalor.tweed5.patchwork.api.PatchworkPartAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class PatchworkFactoryImpl
implements PatchworkFactory {
    private final UUID factoryUuid;
    private final Class<?>[] partClasses;

    @Override
    public Patchwork create() {
        return new PatchworkImpl(new Object[this.partClasses.length]);
    }

    @Generated
    private PatchworkFactoryImpl(UUID factoryUuid, Class<?>[] partClasses) {
        this.factoryUuid = factoryUuid;
        this.partClasses = partClasses;
    }

    private class PatchworkImpl
    implements Patchwork {
        private final @Nullable Object[] partValues;

        @Override
        public <T> T get(PatchworkPartAccess<T> access) throws InvalidPatchworkAccessException {
            PartAccessImpl<T> castedAccess = this.validatePartAccess(access);
            return (T)this.partValues[((PartAccessImpl)castedAccess).partIndex];
        }

        @Override
        public <T> void set(PatchworkPartAccess<T> access, T value) throws InvalidPatchworkAccessException {
            PartAccessImpl<T> castedAccess = this.validatePartAccess(access);
            if (value != null && !PatchworkFactoryImpl.this.partClasses[((PartAccessImpl)castedAccess).partIndex].isInstance(value)) {
                throw new IllegalArgumentException("value " + value + " of type " + value.getClass().getName() + " doesn't match registered value class " + PatchworkFactoryImpl.this.partClasses[((PartAccessImpl)castedAccess).partIndex].getName());
            }
            this.partValues[((PartAccessImpl)castedAccess).partIndex] = value;
        }

        private <T> PartAccessImpl<T> validatePartAccess(PatchworkPartAccess<T> access) throws InvalidPatchworkAccessException {
            if (!(access instanceof PartAccessImpl)) {
                throw new InvalidPatchworkAccessException("Part access is of incorrect class.");
            }
            if (((PartAccessImpl)access).factoryUuid != PatchworkFactoryImpl.this.factoryUuid) {
                throw new InvalidPatchworkAccessException("Part access does not belong to the same patchwork factory.");
            }
            return (PartAccessImpl)access;
        }

        @Override
        public Patchwork copy() {
            return new PatchworkImpl(Arrays.copyOf(this.partValues, this.partValues.length));
        }

        @Generated
        public PatchworkImpl(Object[] partValues) {
            this.partValues = partValues;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PatchworkImpl)) {
                return false;
            }
            PatchworkImpl other = (PatchworkImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.deepEquals(this.partValues, other.partValues);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PatchworkImpl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.partValues);
            return result;
        }
    }

    private static class PartAccessImpl<T>
    implements PatchworkPartAccess<T> {
        private final UUID factoryUuid;
        private final int partIndex;

        @Generated
        public PartAccessImpl(UUID factoryUuid, int partIndex) {
            this.factoryUuid = factoryUuid;
            this.partIndex = partIndex;
        }
    }

    public static class Builder
    implements PatchworkFactory.Builder {
        private final UUID factoryUuid = UUID.randomUUID();
        private final List<Class<?>> partClasses = new ArrayList();
        private boolean built;

        @Override
        public <T> PatchworkPartAccess<T> registerPart(Class<T> partClass) {
            this.requireFresh();
            this.partClasses.add(partClass);
            return new PartAccessImpl(this.factoryUuid, this.partClasses.size() - 1);
        }

        @Override
        public PatchworkFactory build() {
            this.requireFresh();
            this.built = true;
            return new PatchworkFactoryImpl(this.factoryUuid, this.partClasses.toArray(new Class[0]));
        }

        private void requireFresh() {
            if (this.built) {
                throw new IllegalStateException("Builder has already been used.");
            }
        }
    }
}

