/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.config;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.LoadedConfig;
import net.blay09.mods.balm.api.config.MutableLoadedConfig;
import net.blay09.mods.balm.api.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.api.event.ConfigLoadedEvent;
import net.blay09.mods.balm.api.event.server.ServerStartingEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.blay09.mods.balm.common.config.AbstractBalmConfig;
import net.blay09.mods.balm.fabric.config.FabricConfigLoader;
import net.blay09.mods.balm.fabric.config.FabricConfigSaver;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class FabricBalmConfig
extends AbstractBalmConfig {
    private static final Logger logger = LogUtils.getLogger();
    private final AtomicReference<MinecraftServer> currentServer = new AtomicReference();

    @Override
    public void registerConfig(BalmConfigSchema schema) {
        super.registerConfig(schema);
        if (!this.isServerScoped(schema)) {
            this.loadLocalConfig(schema);
        } else {
            MutableLoadedConfig defaultConfig = schema.defaults().mutable(schema);
            this.setLocalConfig(schema, defaultConfig);
            this.setActiveConfig(schema, defaultConfig);
            Balm.events().onEvent(ServerStartingEvent.class, event -> {
                this.currentServer.set(event.getServer());
                this.loadLocalConfig(schema);
            });
            Balm.events().onEvent(ServerStoppedEvent.class, event -> this.currentServer.set(null));
        }
    }

    private void loadLocalConfig(BalmConfigSchema schema) {
        LoadedConfig config = this.loadConfigFromConfigFile(schema);
        MutableLoadedConfig mutableConfig = config.mutable(schema);
        this.setLocalConfig(schema, mutableConfig);
        this.setActiveConfig(schema, config);
        this.fireConfigLoadHandlers(schema, mutableConfig);
        Balm.events().fireEvent(new ConfigLoadedEvent(schema));
    }

    @Override
    public File getConfigDir() {
        return FabricLoader.getInstance().getConfigDir().toFile();
    }

    @Override
    public void saveLocalConfig(BalmConfigSchema schema, MutableLoadedConfig config) {
        super.saveLocalConfig(schema, config);
        File configFile = this.getConfigFile(schema);
        try {
            FabricConfigSaver.save(configFile, schema, config);
        }
        catch (IOException e) {
            logger.error("Failed to save config file {}", (Object)configFile, (Object)e);
        }
    }

    private LoadedConfig loadConfigFromConfigFile(BalmConfigSchema schema) {
        File configFile = this.getConfigFile(schema);
        LoadedConfig config = schema.defaults();
        if (configFile.exists()) {
            try {
                config = FabricConfigLoader.load(configFile, schema);
            }
            catch (IOException e) {
                logger.error("Failed to load config file {}", (Object)configFile, (Object)e);
            }
        } else {
            try {
                FabricConfigSaver.save(configFile, schema, schema.defaults());
            }
            catch (IOException e) {
                logger.error("Failed to generate config file {}", (Object)configFile, (Object)e);
            }
        }
        return config;
    }

    @Override
    public File getConfigDir(BalmConfigSchema schema) {
        if (this.isServerScoped(schema)) {
            MinecraftServer server = this.currentServer.get();
            if (server != null) {
                return server.method_27050(class_5218.field_24188).resolve("serverconfig").toFile();
            }
            throw new IllegalStateException("Cannot get config file for " + String.valueOf(schema) + " without a server running.");
        }
        return super.getConfigDir(schema);
    }

    private boolean isServerScoped(BalmConfigSchema schema) {
        return schema.identifier().method_12832().equals("server");
    }
}

