/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.text.utils;

import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_3544;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5225;
import net.minecraft.class_5481;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class TextBoxStringUtils {
    private static boolean feedChar(class_5224 consumer, int i, char c) {
        return Character.isSurrogate(c) ? consumer.accept(i, class_2583.field_24360, 65533) : consumer.accept(i, class_2583.field_24360, (int)c);
    }

    private static boolean iterate(String string, int start, class_5224 consumer) {
        for (int i = start; i < string.length(); ++i) {
            char character = string.charAt(i);
            if (Character.isHighSurrogate(character)) {
                if (i + 1 >= string.length()) {
                    return consumer.accept(i, class_2583.field_24360, 65533);
                }
                char nextCharacter = string.charAt(i + 1);
                if (Character.isLowSurrogate(nextCharacter)) {
                    if (!consumer.accept(i, class_2583.field_24360, Character.toCodePoint(character, nextCharacter))) {
                        return false;
                    }
                    ++i;
                    continue;
                }
                if (consumer.accept(i, class_2583.field_24360, 65533)) continue;
                return false;
            }
            if (TextBoxStringUtils.feedChar(consumer, i, character)) continue;
            return false;
        }
        return true;
    }

    public static class_5481 format(String text) {
        return class_5481.method_30747((String)text, (class_2583)class_2583.field_24360);
    }

    public static int width(class_327 font, String text) {
        return font.method_30880(TextBoxStringUtils.format(text));
    }

    public static void split(class_327 font, String text, int maxWidth, class_5225.class_5229 consumer) {
        int index = 0;
        while (index < text.length()) {
            LineBreakFinder finder = new LineBreakFinder(maxWidth, font);
            if (TextBoxStringUtils.iterate(text, index, finder)) {
                consumer.accept(class_2583.field_24360, index, text.length());
                break;
            }
            int pos = finder.getSplitPosition();
            char character = text.charAt(pos);
            consumer.accept(class_2583.field_24360, index, pos);
            index = character != '\n' && character != ' ' ? pos : pos + 1;
        }
    }

    public static String plainHeadByWidth(class_327 font, String string, int maxWidth) {
        WidthLimitedCharSink sink = new WidthLimitedCharSink(font, maxWidth);
        TextBoxStringUtils.iterate(string, 0, sink);
        return string.substring(0, sink.position);
    }

    public static String plainTailByWidth(class_327 font, String string, int maxWidth) {
        MutableFloat totalWidth = new MutableFloat();
        MutableInt pos = new MutableInt();
        class_5223.method_27478((String)string, (class_2583)class_2583.field_24360, (i, style, c) -> {
            float width = totalWidth.addAndGet((float)TextBoxStringUtils.width(font, Character.toString(c)));
            if (width > (float)maxWidth) {
                return false;
            }
            pos.setValue(i);
            return true;
        });
        return string.substring(pos.getValue());
    }

    public static boolean isAllowedChatCharacter(int character) {
        return class_3544.method_57175((int)character) || character == 167;
    }

    public static String filterText(String text) {
        StringBuilder builder = new StringBuilder(text.length());
        for (char c : text.toCharArray()) {
            if (!TextBoxStringUtils.isAllowedChatCharacter(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    private static class LineBreakFinder
    implements class_5224 {
        private final int maxWidth;
        private final class_327 font;
        private int lineBreak = -1;
        private boolean hadNonZeroWidthChar;
        private int width;
        private int lastSpace = -1;
        private int nextChar;

        public LineBreakFinder(int maxWidth, class_327 font) {
            this.maxWidth = Math.max(maxWidth, 1);
            this.font = font;
        }

        public boolean accept(int i, @NotNull class_2583 style, int j) {
            switch (j) {
                case 10: {
                    this.lineBreak = i;
                    return false;
                }
                case 32: {
                    this.lastSpace = i;
                }
            }
            int width = TextBoxStringUtils.width(this.font, Character.toString(j));
            this.width += width;
            if (!this.hadNonZeroWidthChar || this.width <= this.maxWidth) {
                this.hadNonZeroWidthChar |= (float)width != 0.0f;
                this.nextChar = i + Character.charCount(j);
                return true;
            }
            this.lineBreak = this.lastSpace != -1 ? this.lastSpace : i;
            return false;
        }

        public int getSplitPosition() {
            return this.lineBreak != -1 ? this.lineBreak : this.nextChar;
        }
    }

    private static class WidthLimitedCharSink
    implements class_5224 {
        private final class_327 font;
        private float maxWidth;
        private int position;

        public WidthLimitedCharSink(class_327 font, float maxWidth) {
            this.font = font;
            this.maxWidth = maxWidth;
        }

        public boolean accept(int i, @NotNull class_2583 ignored, int j) {
            this.maxWidth -= (float)TextBoxStringUtils.width(this.font, Character.toString(j));
            if (this.maxWidth >= 0.0f) {
                this.position = i + Character.charCount(j);
                return true;
            }
            return false;
        }
    }
}

