/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigElement;
import com.teamresourceful.resourcefulconfig.client.ConfigScreenContext;
import com.teamresourceful.resourcefulconfig.client.components.categories.CategoriesListWidget;
import com.teamresourceful.resourcefulconfig.client.components.categories.CategoryItem;
import com.teamresourceful.resourcefulconfig.client.components.header.HeaderWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.Options;
import com.teamresourceful.resourcefulconfig.client.components.options.OptionsListWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.StringOptionWidget;
import com.teamresourceful.resourcefulconfig.client.screens.base.CloseableScreen;
import java.util.ArrayList;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ConfigScreen
extends class_437
implements CloseableScreen {
    private final class_437 parent;
    private final ResourcefulConfig config;
    private final ConfigScreenContext context;
    private OptionsListWidget optionsList = null;
    private CategoriesListWidget categoriesList = null;
    private StringOptionWidget searchWidget = null;

    public ConfigScreen(class_437 parent, ResourcefulConfig config) {
        this(parent, config, new ConfigScreenContext());
    }

    public ConfigScreen(class_437 parent, ResourcefulConfig config, ConfigScreenContext context) {
        super(class_5244.field_39003);
        this.parent = parent;
        this.config = config;
        this.context = context;
    }

    protected void method_41843() {
        OptionsListWidget oldList = this.optionsList;
        super.method_41843();
        this.optionsList.update(oldList);
    }

    protected void method_25426() {
        boolean categoriesEmpty;
        int contentWidth = this.field_22789 - 20;
        int contentHeight = this.field_22790 - 20;
        int optionsWidth = contentWidth;
        class_8667 layout = class_8667.method_52741().method_52735(10);
        HeaderWidget header = (HeaderWidget)layout.method_52736((class_8021)new HeaderWidget(this.field_22789 - 20, this.config, this.context, () -> {
            this.updateOptions();
            this.updateCategories();
        }));
        this.searchWidget = header.getSearchWidget();
        contentHeight -= header.method_25364() + 10;
        class_8667 body = (class_8667)layout.method_52736((class_8021)class_8667.method_52742().method_52735(10));
        boolean bl = categoriesEmpty = this.config.categories().isEmpty() || this.config.categories().values().stream().allMatch(it -> it.info().isHidden());
        if (!categoriesEmpty) {
            int categoryWidth = contentWidth / 4;
            this.categoriesList = (CategoriesListWidget)body.method_52736((class_8021)new CategoriesListWidget(categoryWidth, contentHeight));
            this.updateCategories();
            optionsWidth = contentWidth - categoryWidth - 10;
        }
        this.optionsList = (OptionsListWidget)body.method_52736((class_8021)new OptionsListWidget(optionsWidth, contentHeight));
        this.updateOptions();
        layout.method_48222();
        layout.method_48229(10, 10);
        layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    public void updateOptions() {
        this.optionsList.clear();
        ArrayList<ResourcefulConfigElement> elements = new ArrayList<ResourcefulConfigElement>();
        for (ResourcefulConfigElement element : this.config.elements()) {
            if (!this.context.fulfillsSearch(element)) continue;
            elements.add(element);
        }
        Options.populateOptions(this.optionsList, elements);
    }

    public void updateCategories() {
        if (this.categoriesList == null) {
            return;
        }
        this.categoriesList.clear();
        for (ResourcefulConfig value : this.config.categories().values()) {
            if (!this.context.fulfillsSearch(value) || value.info().isHidden()) continue;
            this.categoriesList.add(new CategoryItem(this, value, this.context));
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, -15526633);
    }

    public boolean method_25402(@NotNull class_11909 event, boolean bl) {
        if (this.method_19355(event.comp_4798(), event.comp_4799()).isEmpty()) {
            this.method_25395(null);
            return false;
        }
        return super.method_25402(event, bl);
    }

    public boolean method_25404(@NotNull class_11908 event) {
        if (event.method_74240() && event.method_74228() == 70 && this.searchWidget != null) {
            this.method_25395((class_364)this.searchWidget);
            this.searchWidget.method_25365(true);
            return true;
        }
        if (super.method_25404(event)) {
            return true;
        }
        if (event.method_74228() == 256) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public boolean method_25422() {
        return false;
    }

    @Override
    public void onClosed(@Nullable class_437 screen) {
        boolean shouldSave;
        boolean bl = shouldSave = screen == null || screen == this.parent && !(this.parent instanceof ConfigScreen);
        if (shouldSave) {
            this.config.save();
        }
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }
}

