/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes.addon.pack;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.minecraft.class_3545;
import xeed.mc.streamotes.addon.TwitchEmotesAPI;
import xeed.mc.streamotes.api.EmoteLoaderException;
import xeed.mc.streamotes.emoticon.Emoticon;
import xeed.mc.streamotes.emoticon.EmoticonRegistry;

public class BTTVChannelPack {
    private static final String URL_TEMPLATE = "https://cdn.betterttv.net/emote/{{id}}/2x.webp";
    private static final int PRIO = 2;

    public static void loadMetadata(String channelName) {
        try {
            URL apiURL = TwitchEmotesAPI.getURL("https://api.betterttv.net/3/cached/users/twitch/" + TwitchEmotesAPI.getChannelId(channelName));
            JsonObject root = TwitchEmotesAPI.getJsonObj(apiURL);
            if (root == null || !root.has("channelEmotes")) {
                throw new EmoteLoaderException("Failed to grab BTTV channel emotes (unexpected status)");
            }
            JsonArray chEmotes = TwitchEmotesAPI.getJsonArray(root, "channelEmotes");
            JsonArray shEmotes = TwitchEmotesAPI.getJsonArray(root, "sharedEmotes");
            for (JsonElement emote : Iterables.concat((Iterable)chEmotes, (Iterable)shEmotes)) {
                JsonObject entry = emote.getAsJsonObject();
                String code = TwitchEmotesAPI.getJsonString(entry, "code");
                Emoticon emoticon = EmoticonRegistry.registerEmoticon(channelName, code, 2, BTTVChannelPack::loadEmoticonImage);
                if (emoticon == null) continue;
                emoticon.setLoadData(new class_3545((Object)TwitchEmotesAPI.getJsonString(entry, "id"), (Object)TwitchEmotesAPI.getJsonString(entry, "imageType")));
                emoticon.setTooltip(channelName + " (BTTV)");
            }
        }
        catch (FileNotFoundException apiURL) {
        }
        catch (Exception e) {
            throw new EmoteLoaderException("Unhandled exception", e);
        }
    }

    private static void loadEmoticonImage(Emoticon emoticon) {
        class_3545 data = (class_3545)emoticon.getLoadData();
        try {
            TwitchEmotesAPI.loadEmoteImage(emoticon, new URI(URL_TEMPLATE.replace("{{id}}", (CharSequence)data.method_15442())), "bttv", (String)data.method_15442());
        }
        catch (URISyntaxException e) {
            throw new EmoteLoaderException(e);
        }
    }
}

