/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes.addon;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import xeed.mc.streamotes.InternalMethods;
import xeed.mc.streamotes.StreamotesCommon;
import xeed.mc.streamotes.api.EmoteLoaderException;
import xeed.mc.streamotes.emoticon.Emoticon;

public class TwitchEmotesAPI {
    private static final int CACHE_LIFETIME_IMAGE = 604800000;
    private static final boolean CACHE_EMOTES = true;
    private static final HashMap<String, CacheEntry<JsonElement>> jsonCache = new HashMap();
    private static final HashMap<String, CacheEntry<String>> channelIdCache = new HashMap();
    private static final Gson gson = new Gson();
    private static File cacheDir;
    private static File cachedEmotes;

    public static void initialize(File mcDataDir) {
        cacheDir = new File(mcDataDir, "emoticons/cache");
        cachedEmotes = new File(cacheDir, "images/");
    }

    public static void concentrateLines(BufferedReader reader, Consumer<String> action) throws IOException {
        String line;
        StringBuilder buffer = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.isBlank() && !buffer.isEmpty()) {
                line = buffer.toString();
                buffer.setLength(0);
                action.accept(line);
                continue;
            }
            if (line.isBlank()) continue;
            buffer.append(line);
        }
    }

    public static URL getURL(String url) {
        try {
            return new URI(url).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream openStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:135.0) Gecko/20100101 Firefox/135.0");
        return conn.getInputStream();
    }

    private static <T> T getJson(InputStream stream, Class<T> cls) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            Object object = gson.fromJson((Reader)reader, cls);
            return (T)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends JsonElement> JsonElement getJson(URL url, Class<T> cls) throws IOException {
        HashMap<String, CacheEntry<JsonElement>> hashMap = jsonCache;
        synchronized (hashMap) {
            CacheEntry<JsonElement> entry = jsonCache.get(url.toString());
            if (entry != null && entry.expTime() <= System.currentTimeMillis()) {
                return entry.item();
            }
            JsonElement json = (JsonElement)TwitchEmotesAPI.getJson(TwitchEmotesAPI.openStream(url), cls);
            jsonCache.put(url.toString(), new CacheEntry<JsonElement>(json, System.currentTimeMillis() + 60000L));
            return json;
        }
    }

    public static JsonObject getJsonObj(URL url) throws IOException {
        return TwitchEmotesAPI.getJson(url, JsonObject.class).getAsJsonObject();
    }

    public static JsonArray getJsonArr(URL url) throws IOException {
        return TwitchEmotesAPI.getJson(url, JsonArray.class).getAsJsonArray();
    }

    private static HttpURLConnection makeGQL(String name) throws IOException {
        URL apiURL = TwitchEmotesAPI.getURL("https://7tv.io/v3/gql");
        HttpURLConnection conn = (HttpURLConnection)apiURL.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("User-Agent", "insomnia/9.3.3");
        conn.setDoOutput(true);
        String query = "query FindUser($name: String!) { users(query: $name) { id username connections { id platform display_name } } }";
        String vars = "{ \"name\": \"" + name + "\" }";
        String body = "{\"query\": \"" + query + "\",\"operationName\": \"FindUser\",\"variables\": " + vars + "}";
        try (DataOutputStream writer = new DataOutputStream(conn.getOutputStream());){
            writer.writeBytes(body);
            writer.flush();
        }
        return conn;
    }

    public static String getChannelId(String name) throws IOException {
        HashMap<String, CacheEntry<String>> hashMap = channelIdCache;
        synchronized (hashMap) {
            CacheEntry<String> entry = channelIdCache.get(name);
            if (entry != null && entry.expTime() <= System.currentTimeMillis()) {
                return entry.item();
            }
            HttpURLConnection conn = TwitchEmotesAPI.makeGQL(name);
            int code = conn.getResponseCode();
            if (code / 100 != 2) {
                String info = IOUtils.toString((InputStream)conn.getErrorStream(), (Charset)StandardCharsets.UTF_8);
                throw new IOException("Channel ID request for name " + name + " returned " + code + ": " + info);
            }
            JsonObject data = TwitchEmotesAPI.getJson(conn.getInputStream(), JsonObject.class);
            try {
                List users = data.getAsJsonObject("data").getAsJsonArray("users").asList();
                boolean nameFound = false;
                for (JsonElement uelem : users) {
                    JsonObject user = uelem.getAsJsonObject();
                    if (!user.get("username").getAsString().equalsIgnoreCase(name)) continue;
                    nameFound = true;
                    List conns = user.getAsJsonArray("connections").asList();
                    for (JsonElement celem : conns) {
                        JsonObject cdata = celem.getAsJsonObject();
                        if (!cdata.get("platform").getAsString().equals("TWITCH")) continue;
                        String channelId = cdata.get("id").getAsString();
                        channelIdCache.put(name, new CacheEntry<String>(channelId, System.currentTimeMillis() + 300000L));
                        return channelId;
                    }
                }
                if (nameFound) {
                    throw new IOException("7tv profile " + name + " has no associated Twitch channel");
                }
                throw new IOException("Channel " + name + " has no valid 7tv profile");
            }
            catch (IndexOutOfBoundsException | NullPointerException e) {
                throw new IOException("Invalid json trying to get channel ID of " + name + ": " + data.toString(), e);
            }
        }
    }

    private static boolean shouldUseCacheFileImage(File file) {
        return file.exists() && System.currentTimeMillis() - file.lastModified() <= 604800000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadEmoteImage(Emoticon emote, URI source, String cacheId, String imageId) {
        File cachedImageFile = new File(cachedEmotes, cacheId + "-" + imageId + ".png");
        if (TwitchEmotesAPI.shouldUseCacheFileImage(cachedImageFile)) {
            if (InternalMethods.loadImage(emote, cachedImageFile)) {
                return;
            }
            TwitchEmotesAPI.clearFileCache();
        }
        if (InternalMethods.loadImage(emote, source)) {
            try {
                File cacheDir = cachedImageFile.getParentFile();
                if (cacheDir.exists() || cacheDir.mkdirs()) {
                    emote.writeImage(cachedImageFile);
                    if (emote.isAnimated()) {
                        Files.write(new File(cachedImageFile.getParentFile(), cachedImageFile.getName() + ".txt").toPath(), (Iterable<? extends CharSequence>)IntStream.concat(IntStream.of(emote.getWidth(), emote.getHeight()), IntStream.of(emote.getFrameTimes())).mapToObj(Integer::toString).collect(Collectors.toList()), StandardCharsets.UTF_8, new OpenOption[0]);
                    }
                }
            }
            catch (IOException e) {
                StreamotesCommon.loge("Cache writing failed for " + emote.getName(), e);
            }
            finally {
                emote.discardBitmap();
            }
        }
    }

    public static void clearFileCache() {
        try {
            FileUtils.deleteDirectory((File)cacheDir);
        }
        catch (IOException e) {
            StreamotesCommon.loge("Cache purge failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJsonCache() {
        HashMap<String, CacheEntry<JsonElement>> hashMap = jsonCache;
        synchronized (hashMap) {
            jsonCache.clear();
        }
    }

    public static String getJsonString(JsonObject object, String name) {
        JsonElement element = object.get(name);
        if (element == null) {
            throw new EmoteLoaderException("'" + name + "' is null");
        }
        try {
            return element.getAsString();
        }
        catch (ClassCastException e) {
            throw new EmoteLoaderException("name: " + name, e);
        }
    }

    public static JsonArray getJsonArray(JsonObject object, String name) {
        try {
            JsonArray result = object.getAsJsonArray(name);
            if (result == null) {
                throw new EmoteLoaderException("'" + name + "' is null");
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new EmoteLoaderException("name: " + name, e);
        }
    }

    private record CacheEntry<T>(T item, long expTime) {
    }
}

