/*
 * Decompiled with CFR 0.152.
 */
package xeed.mc.streamotes;

import com.madgag.gif.fmsware.GifDecoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.class_3545;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xeed.mc.streamotes.Streamotes;
import xeed.mc.streamotes.StreamotesCommon;

public class ImageHandler {
    public static final Color TRANSPARENT = new Color(255, 255, 255, 0);

    public static List<class_3545<BufferedImage, Integer>> readImages(InputStream source) throws IOException {
        IOException lastEx = null;
        var output = new ByteArrayOutputStream(){

            public synchronized byte[] getBuffer() {
                return this.buf;
            }
        };
        source.transferTo(output);
        ByteArrayInputStream input = new ByteArrayInputStream(output.getBuffer(), 0, output.size());
        try (ImageInputStream in = ImageIO.createImageInputStream(input);){
            Iterator iterator = ((Iterable)() -> ImageIO.getImageReaders(in)).iterator();
            if (iterator.hasNext()) {
                ImageReader reader = (ImageReader)iterator.next();
                Streamotes.log("Trying " + reader.getClass().getName() + ", Format " + reader.getFormatName());
                if (reader.getFormatName().equals("gif")) {
                    input.reset();
                    List<class_3545<BufferedImage, Integer>> list = ImageHandler.readGifFrames(input);
                    return list;
                }
                reader.setInput(in);
                List<ImageFrame> frames = ImageHandler.readFrames(reader);
                ArrayList<class_3545> result = new ArrayList<class_3545>(frames.size());
                for (ImageFrame frame : frames) {
                    result.add(new class_3545((Object)frame.image(), (Object)frame.delay()));
                }
                ArrayList<class_3545> arrayList = result;
                return arrayList;
            }
        }
        if (lastEx != null) {
            throw new IOException("All image readers failed", lastEx);
        }
        return Collections.emptyList();
    }

    private static List<class_3545<BufferedImage, Integer>> readGifFrames(InputStream input) {
        GifDecoder decoder = new GifDecoder();
        decoder.read(input);
        int count = decoder.getFrameCount();
        ArrayList<class_3545<BufferedImage, Integer>> frames = new ArrayList<class_3545<BufferedImage, Integer>>(count);
        for (int i = 0; i < count; ++i) {
            int delay = decoder.getDelay(i);
            frames.add((class_3545<BufferedImage, Integer>)new class_3545((Object)decoder.getFrame(i), (Object)(delay <= 10 ? 100 : delay)));
        }
        return frames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ImageFrame> readFrames(ImageReader reader) throws IOException {
        ArrayList<ImageFrame> frames = new ArrayList<ImageFrame>(1);
        try {
            int frameIndex;
            BufferedImage master = null;
            Graphics2D baseImage = null;
            int width = -1;
            int height = -1;
            int numFrames = reader.getNumImages(true);
            frames.ensureCapacity(numFrames);
            Dimension size = ImageHandler.extractLogicalScreenSize(reader);
            if (size != null) {
                width = size.width;
                height = size.height;
            } else {
                for (frameIndex = 0; frameIndex < numFrames; ++frameIndex) {
                    FrameMetadata meta = ImageHandler.getFrameMetadata(reader, frameIndex);
                    width = Math.max(width, reader.getWidth(frameIndex) + meta.x);
                    height = Math.max(height, reader.getHeight(frameIndex) + meta.y);
                }
            }
            for (frameIndex = 0; frameIndex < numFrames; ++frameIndex) {
                BufferedImage img;
                try {
                    img = reader.read(frameIndex);
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
                FrameMetadata imageMetadata = ImageHandler.getFrameMetadata(reader, frameIndex);
                int x = imageMetadata.x;
                int y = imageMetadata.y;
                if (master == null) {
                    master = new BufferedImage(width, height, 2);
                    baseImage = ImageHandler.prepareGraphics(master);
                }
                baseImage.setComposite(imageMetadata.alphaSrcOver ? AlphaComposite.SrcOver : AlphaComposite.Src);
                baseImage.drawImage(img, x, y, TRANSPARENT, null);
                BufferedImage copy = ImageHandler.cloneImage(master);
                ImageFrame imageFrame = new ImageFrame(copy, imageMetadata.delay, imageMetadata.disposal);
                frames.add(imageFrame);
                if (DisposalType.PREVIOUS == imageMetadata.disposal) {
                    BufferedImage from = null;
                    for (int i = frameIndex - 1; i >= 0; --i) {
                        ImageFrame frame = frames.get(i);
                        if (DisposalType.PREVIOUS == frame.disposal && frameIndex != 0) continue;
                        from = frame.image;
                        break;
                    }
                    if (from == null) continue;
                    master = ImageHandler.cloneImage(from);
                    baseImage = ImageHandler.prepareGraphics(master);
                    continue;
                }
                if (imageMetadata.disposal != DisposalType.BACKGROUND && imageMetadata.disposal != DisposalType.REPLACE) continue;
                baseImage.clearRect(x, y, img.getWidth(), img.getHeight());
            }
            ArrayList<ImageFrame> arrayList = frames;
            return arrayList;
        }
        finally {
            reader.dispose();
        }
    }

    private static BufferedImage cloneImage(BufferedImage image) {
        WritableRaster raster = image.copyData(image.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(image.getColorModel(), raster, image.isAlphaPremultiplied(), null);
    }

    private static Graphics2D prepareGraphics(BufferedImage image) {
        Graphics2D g = image.createGraphics();
        g.setBackground(new Color(0, 0, 0, 0));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return g;
    }

    private static Dimension extractLogicalScreenSize(ImageReader reader) {
        try {
            IIOMetadataNode screenDescriptor;
            IIOMetadata metadata = reader.getStreamMetadata();
            if (metadata == null) {
                return null;
            }
            IIOMetadataNode globalRoot = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
            NodeList globalScreenDescriptor = globalRoot.getElementsByTagName("LogicalScreenDescriptor");
            if (globalScreenDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreenDescriptor.item(0)) != null) {
                return new Dimension(Integer.parseInt(screenDescriptor.getAttribute("logicalScreenWidth")), Integer.parseInt(screenDescriptor.getAttribute("logicalScreenHeight")));
            }
        }
        catch (IOException e) {
            StreamotesCommon.loge("Display metadata extraction failed", e);
        }
        return null;
    }

    private static FrameMetadata getFrameMetadata(ImageReader reader, int frameIndex) throws IOException {
        FrameMetadata result = null;
        if (reader.getFormatName().equalsIgnoreCase("gif")) {
            result = ImageHandler.fromGifMetadata(reader, frameIndex);
        } else if (reader.getClass().getName().equals("com.twelvemonkeys.imageio.plugins.webp.WebPImageReader")) {
            result = ImageHandler.fromWebPImageReader(reader, frameIndex);
        }
        return result != null ? result : new FrameMetadata(0, 0, 100, DisposalType.BACKGROUND, false);
    }

    private static FrameMetadata fromGifMetadata(ImageReader reader, int frameIndex) {
        try {
            IIOMetadata metadata = reader.getImageMetadata(frameIndex);
            IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree("javax_imageio_gif_image_1.0");
            IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
            int delay = Integer.parseInt(gce.getAttribute("delayTime")) * 10;
            if (delay < 20) {
                delay = 100;
            }
            String disposal = gce.getAttribute("disposalMethod");
            int x = 0;
            int y = 0;
            NodeList children = root.getChildNodes();
            for (int nodeIndex = 0; nodeIndex < children.getLength(); ++nodeIndex) {
                Node nodeItem = children.item(nodeIndex);
                if (!"ImageDescriptor".equalsIgnoreCase(nodeItem.getNodeName())) continue;
                NamedNodeMap map = nodeItem.getAttributes();
                x = Integer.parseInt(map.getNamedItem("imageLeftPosition").getNodeValue());
                y = Integer.parseInt(map.getNamedItem("imageTopPosition").getNodeValue());
            }
            return new FrameMetadata(x, y, delay, DisposalType.fromKey(disposal), true);
        }
        catch (IOException e) {
            StreamotesCommon.loge("GIF metadata extraction failed", e);
            return null;
        }
    }

    private static Field getField(Class<?> cls, String name) throws NoSuchFieldException {
        Field f = cls.getDeclaredField(name);
        f.setAccessible(true);
        return f;
    }

    private static FrameMetadata fromWebPImageReader(ImageReader reader, int frameIndex) {
        try {
            List framesData = (List)ImageHandler.getField(reader.getClass(), "frames").get(reader);
            if (frameIndex >= framesData.size()) {
                return null;
            }
            Object frameData = framesData.get(frameIndex);
            int duration = ImageHandler.getField(frameData.getClass(), "duration").getInt(frameData);
            boolean blend = ImageHandler.getField(frameData.getClass(), "blend").getBoolean(frameData);
            boolean dispose = ImageHandler.getField(frameData.getClass(), "dispose").getBoolean(frameData);
            Rectangle bounds = (Rectangle)ImageHandler.getField(frameData.getClass(), "bounds").get(frameData);
            return new FrameMetadata(bounds.x, bounds.y, duration, dispose ? DisposalType.BACKGROUND : DisposalType.NONE, blend);
        }
        catch (ReflectiveOperationException e) {
            StreamotesCommon.loge("WebP metadata extraction failed", e);
            return null;
        }
    }

    private record ImageFrame(BufferedImage image, int delay, DisposalType disposal) {
    }

    private record FrameMetadata(int x, int y, int delay, DisposalType disposal, boolean alphaSrcOver) {
    }

    private static enum DisposalType {
        REPLACE("none"),
        NONE("doNotDispose"),
        BACKGROUND("restoreToBackgroundColor"),
        PREVIOUS("restoreToPrevious");

        public final String key;

        private DisposalType(String key) {
            this.key = key;
        }

        public static DisposalType fromKey(String key) {
            for (DisposalType type : DisposalType.values()) {
                if (!type.key.equals(key)) continue;
                return type;
            }
            return REPLACE;
        }
    }
}

