/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.utils.forge;

import forge.me.thosea.badoptimizations.config.Config;
import forge.me.thosea.badoptimizations.hook.CacheHooks;
import forge.me.thosea.badoptimizations.hook.HookCreator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;

public final class PlatformMethodsImpl {
    private PlatformMethodsImpl() {
    }

    public static String getVersion() {
        return ModList.get().getModContainerById("badoptimizations").map(mod -> mod.getModInfo().getVersion().toString()).orElse("[unknown version]");
    }

    public static Path getConfigFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static boolean isModLoaded(String id) {
        return PlatformMethodsImpl.modList().getModFileById(id) != null;
    }

    public static boolean isOnServer() {
        return FMLLoader.getCurrent().getDist() == Dist.DEDICATED_SERVER;
    }

    public static InputStream streamConfigTemplate() throws IOException {
        return PlatformMethodsImpl.modList().getModFileById("badoptimizations").getFile().getContents().openFile("bo-config-template.txt");
    }

    public static Map<String, List<String>> getModIncompatibilities() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(1);
        for (ModInfo mod : PlatformMethodsImpl.modList().getMods()) {
            Map map;
            String id = mod.getModId();
            Optional object = mod.getOwningFile().getConfigElement(new String[]{"badoptimizations:incompatibilities"});
            if (object.isEmpty()) continue;
            Object object2 = object.get();
            if (!(object2 instanceof Map) || !((object2 = PlatformMethodsImpl.castMap(map = (Map)object2).get("options")) instanceof List)) {
                Config.LOGGER.warn("Mod {} specifies invalid BadOptimizations incompatibilities, ignoring", (Object)id);
                Config.LOGGER.warn("TOML is not a map containing a string list named options");
                continue;
            }
            List list = (List)object2;
            ArrayList<String> entries = new ArrayList<String>();
            for (Object element : list) {
                if (!(element instanceof String)) {
                    Config.LOGGER.warn("Mod {} specifies invalid BadOptimizations incompatibilities", (Object)id);
                    Config.LOGGER.warn("TOML options contains non-string value in array");
                    continue;
                }
                String entry = (String)element;
                entries.add(entry);
            }
            result.put(id, entries);
        }
        return result;
    }

    private static <T extends Map<?, ?>> T castMap(Map<?, ?> map) {
        return (T)map;
    }

    public static List<CacheHooks.CacheHookEntry> getModCacheHooks() {
        ArrayList<CacheHooks.CacheHookEntry> result = new ArrayList<CacheHooks.CacheHookEntry>();
        for (ModInfo mod : PlatformMethodsImpl.modList().getMods()) {
            String id = mod.getModId();
            Optional object = mod.getOwningFile().getConfigElement(new String[]{"badoptimizations:cache_hooks"});
            if (object.isEmpty()) continue;
            Object t = object.get();
            if (!(t instanceof Map)) {
                Config.LOGGER.warn("Mod {} specifies invalid BadOptimizations caching hooks, ignoring", (Object)id);
                Config.LOGGER.warn("TOML is not a map");
                continue;
            }
            Map map = (Map)t;
            BooleanSupplier common = PlatformMethodsImpl.getEntry(id, map, "common");
            BooleanSupplier lightmap = PlatformMethodsImpl.getEntry(id, map, "lightmap");
            BooleanSupplier skyColor = PlatformMethodsImpl.getEntry(id, map, "skycolor");
            if (common == null && lightmap == null && skyColor == null) continue;
            CacheHooks.CacheHookEntry entry = new CacheHooks.CacheHookEntry(common, lightmap, skyColor);
            result.add(entry);
        }
        return result;
    }

    private static BooleanSupplier getEntry(String modId, Map<?, ?> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            Config.LOGGER.warn("Mod {} specifies an invalid BadOptimizations caching hook", (Object)modId);
            Config.LOGGER.warn("TOML key {} is not a string", (Object)key);
            return null;
        }
        String string = (String)value;
        BooleanSupplier hook = HookCreator.tryCreateHook(modId, string);
        if (hook != null) {
            Config.LOGGER.info("Mod {} added a {} caching hook: {}", new Object[]{modId, key, string});
        }
        return hook;
    }

    private static LoadingModList modList() {
        return FMLLoader.getCurrent().getLoadingModList();
    }
}

