/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.jankson;

import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonNull;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationAttributes;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.util.RecursiveSerializer;
import java.util.Optional;

public class JanksonSerializer
extends RecursiveSerializer<JsonElement>
implements SelfDescribedSerializer<JsonElement> {
    private JsonElement prefix;

    protected JanksonSerializer(JsonElement prefix) {
        super(null);
        this.prefix = prefix;
    }

    public static JanksonSerializer of(JsonElement prefix) {
        return new JanksonSerializer(prefix);
    }

    public static JanksonSerializer of() {
        return JanksonSerializer.of(null);
    }

    public SerializationContext setupContext(SerializationContext ctx) {
        return super.setupContext(ctx).withAttributes(new SerializationAttribute.Instance[]{SerializationAttributes.HUMAN_READABLE});
    }

    public void writeByte(SerializationContext ctx, byte value) {
        this.consume(new JsonPrimitive((Object)value));
    }

    public void writeShort(SerializationContext ctx, short value) {
        this.consume(new JsonPrimitive((Object)value));
    }

    public void writeInt(SerializationContext ctx, int value) {
        this.consume(new JsonPrimitive((Object)value));
    }

    public void writeLong(SerializationContext ctx, long value) {
        this.consume(new JsonPrimitive((Object)value));
    }

    public void writeFloat(SerializationContext ctx, float value) {
        this.consume(new JsonPrimitive((Object)Float.valueOf(value)));
    }

    public void writeDouble(SerializationContext ctx, double value) {
        this.consume(new JsonPrimitive((Object)value));
    }

    public void writeVarInt(SerializationContext ctx, int value) {
        this.writeInt(ctx, value);
    }

    public void writeVarLong(SerializationContext ctx, long value) {
        this.writeLong(ctx, value);
    }

    public void writeBoolean(SerializationContext ctx, boolean value) {
        this.consume(new JsonPrimitive((Object)value));
    }

    public void writeString(SerializationContext ctx, String value) {
        this.consume(new JsonPrimitive((Object)value));
    }

    public void writeBytes(SerializationContext ctx, byte[] bytes) {
        JsonArray result = new JsonArray();
        for (int i = 0; i < bytes.length; ++i) {
            result.add((JsonElement)new JsonPrimitive((Object)bytes[i]));
        }
        this.consume(result);
    }

    public <V> void writeOptional(SerializationContext ctx, Endec<V> endec, Optional<V> optional) {
        optional.ifPresentOrElse(value -> endec.encode(ctx, (Serializer)this, value), () -> this.consume(JsonNull.INSTANCE));
    }

    public <E> Serializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec, int size) {
        return new Sequence<E>(ctx, elementEndec, size);
    }

    public <V> Serializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec, int size) {
        return new Map<V>(ctx, valueEndec);
    }

    public Serializer.Struct struct() {
        return new Map(null, null);
    }

    private class Sequence<V>
    implements Serializer.Sequence<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final JsonArray result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Sequence(SerializationContext ctx, Endec<V> valueEndec, int size) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            if (JanksonSerializer.this.prefix != null) {
                JsonArray prefixArray;
                JsonElement jsonElement = JanksonSerializer.this.prefix;
                if (!(jsonElement instanceof JsonArray)) throw new IllegalStateException("Incompatible prefix of type " + JanksonSerializer.this.prefix.getClass().getSimpleName() + " used for JSON sequence");
                this.result = prefixArray = (JsonArray)jsonElement;
                JanksonSerializer.this.prefix = null;
                return;
            } else {
                this.result = new JsonArray();
            }
        }

        public void element(V element) {
            JanksonSerializer.this.frame(encoded -> {
                this.valueEndec.encode(this.ctx, (Serializer)JanksonSerializer.this, element);
                this.result.add((JsonElement)encoded.require("sequence element"));
            });
        }

        public void end() {
            JanksonSerializer.this.consume(this.result);
        }
    }

    private class Map<V>
    implements Serializer.Map<V>,
    Serializer.Struct {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final JsonObject result;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Map(SerializationContext ctx, Endec<V> valueEndec) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            if (JanksonSerializer.this.prefix != null) {
                JsonObject prefixObject;
                JsonElement jsonElement = JanksonSerializer.this.prefix;
                if (!(jsonElement instanceof JsonObject)) throw new IllegalStateException("Incompatible prefix of type " + JanksonSerializer.this.prefix.getClass().getSimpleName() + " used for JSON map/struct");
                this.result = prefixObject = (JsonObject)jsonElement;
                JanksonSerializer.this.prefix = null;
                return;
            } else {
                this.result = new JsonObject();
            }
        }

        public void entry(String key, V value) {
            JanksonSerializer.this.frame(encoded -> {
                this.valueEndec.encode(this.ctx, (Serializer)JanksonSerializer.this, value);
                this.result.put(key, (JsonElement)encoded.require("map value"));
            });
        }

        public <F> Serializer.Struct field(String name, SerializationContext ctx, Endec<F> endec, F value, boolean mayOmit) {
            JanksonSerializer.this.frame(encoded -> {
                endec.encode(ctx, (Serializer)JanksonSerializer.this, value);
                JsonElement element = (JsonElement)encoded.require("struct field");
                if (mayOmit && element.equals(JsonNull.INSTANCE)) {
                    return;
                }
                this.result.put(name, element);
            });
            return this;
        }

        public void end() {
            JanksonSerializer.this.consume(this.result);
        }
    }
}

