/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.jankson;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.api.SyntaxError;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.format.jankson.JanksonDeserializer;
import io.wispforest.endec.format.jankson.JanksonSerializer;

public final class JanksonEndec
implements Endec<JsonElement> {
    private static final Jankson JANKSON = new Jankson.Builder().build();
    public static final JanksonEndec INSTANCE = new JanksonEndec();

    private JanksonEndec() {
    }

    public void encode(SerializationContext ctx, Serializer<?> serializer, JsonElement value) {
        if (serializer instanceof SelfDescribedSerializer) {
            JanksonDeserializer.of(value).readAny(ctx, serializer);
            return;
        }
        serializer.writeString(ctx, value.toString());
    }

    public JsonElement decode(SerializationContext ctx, Deserializer<?> deserializer) {
        if (deserializer instanceof SelfDescribedDeserializer) {
            SelfDescribedDeserializer selfDescribedDeserializer = (SelfDescribedDeserializer)deserializer;
            JanksonSerializer json = JanksonSerializer.of();
            selfDescribedDeserializer.readAny(ctx, (Serializer)json);
            return (JsonElement)json.result();
        }
        try {
            return JANKSON.load(deserializer.readString(ctx));
        }
        catch (SyntaxError error) {
            throw new RuntimeException(error);
        }
    }
}

