/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.jankson;

import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonNull;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationAttributes;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.format.jankson.JanksonEndec;
import io.wispforest.endec.util.RecursiveDeserializer;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class JanksonDeserializer
extends RecursiveDeserializer<JsonElement>
implements SelfDescribedDeserializer<JsonElement> {
    protected JanksonDeserializer(JsonElement serialized) {
        super((Object)serialized);
    }

    public static JanksonDeserializer of(JsonElement serialized) {
        return new JanksonDeserializer(serialized);
    }

    public SerializationContext setupContext(SerializationContext ctx) {
        return super.setupContext(ctx).withAttributes(new SerializationAttribute.Instance[]{SerializationAttributes.HUMAN_READABLE});
    }

    public byte readByte(SerializationContext ctx) {
        return this.readPrimitive(Number.class).byteValue();
    }

    public short readShort(SerializationContext ctx) {
        return this.readPrimitive(Number.class).shortValue();
    }

    public int readInt(SerializationContext ctx) {
        return this.readPrimitive(Number.class).intValue();
    }

    public long readLong(SerializationContext ctx) {
        return this.readPrimitive(Number.class).longValue();
    }

    public float readFloat(SerializationContext ctx) {
        return this.readPrimitive(Number.class).floatValue();
    }

    public double readDouble(SerializationContext ctx) {
        return this.readPrimitive(Number.class).doubleValue();
    }

    private <T> T readPrimitive(Class<T> clazz) {
        return clazz.cast(((JsonPrimitive)this.getValue()).getValue());
    }

    public int readVarInt(SerializationContext ctx) {
        return this.readInt(ctx);
    }

    public long readVarLong(SerializationContext ctx) {
        return this.readLong(ctx);
    }

    public boolean readBoolean(SerializationContext ctx) {
        return this.readPrimitive(Boolean.class);
    }

    public String readString(SerializationContext ctx) {
        return this.readPrimitive(String.class);
    }

    public byte[] readBytes(SerializationContext ctx) {
        JsonElement[] array = ((JsonArray)this.getValue()).toArray();
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = ((Number)((JsonPrimitive)array[i]).getValue()).byteValue();
        }
        return result;
    }

    public <V> Optional<V> readOptional(SerializationContext ctx, Endec<V> endec) {
        JsonElement value = (JsonElement)this.getValue();
        return !(value instanceof JsonNull) ? Optional.of(endec.decode(ctx, (Deserializer)this)) : Optional.empty();
    }

    public <E> Deserializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec) {
        return new Sequence<E>(ctx, elementEndec, (JsonArray)this.getValue());
    }

    public <V> Deserializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec) {
        return new Map<V>(ctx, valueEndec, (JsonObject)this.getValue());
    }

    public Deserializer.Struct struct() {
        return new Struct((JsonObject)this.getValue());
    }

    public <S> void readAny(SerializationContext ctx, Serializer<S> visitor) {
        this.decodeValue(ctx, visitor, (JsonElement)this.getValue());
    }

    private <S> void decodeValue(SerializationContext ctx, Serializer<S> visitor, JsonElement element) {
        block30: {
            if (element instanceof JsonNull) {
                visitor.writeOptional(ctx, (Endec)JanksonEndec.INSTANCE, Optional.empty());
            } else if (element instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)element;
                Object object = primitive.getValue();
                if (object instanceof String) {
                    String s = (String)object;
                    visitor.writeString(ctx, s);
                } else {
                    object = primitive.getValue();
                    if (object instanceof Boolean) {
                        Boolean b = (Boolean)object;
                        visitor.writeBoolean(ctx, b.booleanValue());
                    } else {
                        BigDecimal value = primitive.asBigDecimal(BigDecimal.ZERO);
                        try {
                            long asLong = value.longValueExact();
                            if ((long)((byte)asLong) == asLong) {
                                visitor.writeByte(ctx, ((Byte)primitive.getValue()).byteValue());
                                break block30;
                            }
                            if ((long)((short)asLong) == asLong) {
                                visitor.writeShort(ctx, ((Short)primitive.getValue()).shortValue());
                                break block30;
                            }
                            if ((long)((int)asLong) == asLong) {
                                visitor.writeInt(ctx, ((Integer)primitive.getValue()).intValue());
                                break block30;
                            }
                            visitor.writeLong(ctx, asLong);
                        }
                        catch (ArithmeticException bruh) {
                            double asDouble = value.doubleValue();
                            if ((double)((float)asDouble) == asDouble) {
                                visitor.writeFloat(ctx, ((Float)primitive.getValue()).floatValue());
                                break block30;
                            }
                            visitor.writeDouble(ctx, asDouble);
                        }
                    }
                }
            } else if (element instanceof JsonArray) {
                JsonArray array = (JsonArray)element;
                try (Serializer.Sequence sequence = visitor.sequence(ctx, Endec.of(this::decodeValue, (ctx1, deserializer) -> null), array.size());){
                    array.forEach(arg_0 -> ((Serializer.Sequence)sequence).element(arg_0));
                }
            } else if (element instanceof JsonObject) {
                JsonObject object = (JsonObject)element;
                try (Serializer.Map map = visitor.map(ctx, Endec.of(this::decodeValue, (ctx1, deserializer) -> null), object.size());){
                    object.forEach((arg_0, arg_1) -> ((Serializer.Map)map).entry(arg_0, arg_1));
                }
            } else {
                throw new IllegalArgumentException("Non-standard, unrecognized JsonElement implementation cannot be decoded");
            }
        }
    }

    private class Sequence<V>
    implements Deserializer.Sequence<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final Iterator<JsonElement> elements;
        private final int size;

        private Sequence(SerializationContext ctx, Endec<V> valueEndec, JsonArray elements) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.elements = elements.iterator();
            this.size = elements.size();
        }

        public int estimatedSize() {
            return this.size;
        }

        public boolean hasNext() {
            return this.elements.hasNext();
        }

        public V next() {
            JsonElement element = this.elements.next();
            return (V)JanksonDeserializer.this.frame(() -> element, () -> this.valueEndec.decode(this.ctx, (Deserializer)JanksonDeserializer.this));
        }
    }

    private class Map<V>
    implements Deserializer.Map<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final Iterator<Map.Entry<String, JsonElement>> entries;
        private final int size;

        private Map(SerializationContext ctx, Endec<V> valueEndec, JsonObject entries) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.entries = entries.entrySet().iterator();
            this.size = entries.size();
        }

        public int estimatedSize() {
            return this.size;
        }

        public boolean hasNext() {
            return this.entries.hasNext();
        }

        public Map.Entry<String, V> next() {
            Map.Entry<String, JsonElement> entry = this.entries.next();
            return (Map.Entry)JanksonDeserializer.this.frame(entry::getValue, () -> java.util.Map.entry((String)entry.getKey(), this.valueEndec.decode(this.ctx, (Deserializer)JanksonDeserializer.this)));
        }
    }

    private class Struct
    implements Deserializer.Struct {
        private final JsonObject object;

        private Struct(JsonObject object) {
            this.object = object;
        }

        @Nullable
        public <F> F field(String name, SerializationContext ctx, Endec<F> endec, @Nullable Supplier<F> defaultValueFactory) {
            JsonElement element = this.object.get((Object)name);
            if (element == null) {
                if (defaultValueFactory == null) {
                    throw new IllegalStateException("Field '" + name + "' was missing from serialized data, but no default value was provided");
                }
                return defaultValueFactory.get();
            }
            return (F)JanksonDeserializer.this.frame(() -> element, () -> endec.decode(ctx, (Deserializer)JanksonDeserializer.this));
        }
    }
}

