/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed5.dataapi.api;

import de.siphalor.tweed5.dataapi.api.TweedDataReadException;
import de.siphalor.tweed5.dataapi.api.TweedDataReader;
import de.siphalor.tweed5.dataapi.api.TweedDataToken;
import de.siphalor.tweed5.dataapi.api.TweedDataVisitor;
import lombok.Generated;

public class IntuitiveVisitingTweedDataReader {
    private final TweedDataVisitor visitor;

    public void readValue(TweedDataReader reader) throws TweedDataReadException {
        TweedDataToken token = reader.peekToken();
        if (token.isNull()) {
            reader.readToken();
            this.visitor.visitNull();
        } else if (token.isListStart()) {
            this.readList(reader);
        } else if (token.isMapStart()) {
            this.readMap(reader);
        } else if (token.canReadAsByte()) {
            this.visitor.visitByte(reader.readToken().readAsByte());
        } else if (token.canReadAsShort()) {
            this.visitor.visitShort(reader.readToken().readAsShort());
        } else if (token.canReadAsInt()) {
            this.visitor.visitInt(reader.readToken().readAsInt());
        } else if (token.canReadAsLong()) {
            this.visitor.visitLong(reader.readToken().readAsLong());
        } else if (token.canReadAsFloat()) {
            this.visitor.visitFloat(reader.readToken().readAsFloat());
        } else if (token.canReadAsDouble()) {
            this.visitor.visitDouble(reader.readToken().readAsDouble());
        } else if (token.canReadAsBoolean()) {
            this.visitor.visitBoolean(reader.readToken().readAsBoolean());
        } else if (token.canReadAsString()) {
            this.visitor.visitString(reader.readToken().readAsString());
        }
    }

    public void readList(TweedDataReader reader) throws TweedDataReadException {
        TweedDataToken token = reader.readToken();
        if (!token.isListStart()) {
            throw TweedDataReadException.builder().message("Expected list but got " + token).build();
        }
        this.visitor.visitListStart();
        while (true) {
            if ((token = reader.peekToken()).isListEnd()) break;
            this.readValue(reader);
        }
        this.visitor.visitListEnd();
        reader.readToken();
    }

    public void readMap(TweedDataReader reader) throws TweedDataReadException {
        block2: {
            TweedDataToken token = reader.readToken();
            if (!token.isMapStart()) {
                throw TweedDataReadException.builder().message("Expected map but got " + token).build();
            }
            this.visitor.visitMapStart();
            while (true) {
                if ((token = reader.peekToken()).isMapEnd()) break block2;
                if (!token.isMapEntryKey()) break;
                this.visitor.visitMapEntryKey(reader.readToken().readAsString());
                this.readValue(reader);
            }
            throw TweedDataReadException.builder().message("Expected map end or entry key but got " + token).build();
        }
        reader.readToken();
        this.visitor.visitMapEnd();
    }

    @Generated
    public IntuitiveVisitingTweedDataReader(TweedDataVisitor visitor) {
        this.visitor = visitor;
    }
}

