/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.util.reflection;

import io.wispforest.endec.util.reflection.MethodTypeCheckBypass;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtils {
    public static Type getBaseType(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Parameter) {
            Parameter parameter = (Parameter)annotatedElement;
            return parameter.getType();
        }
        if (annotatedElement instanceof Field) {
            Field field = (Field)annotatedElement;
            return field.getGenericType();
        }
        if (annotatedElement instanceof RecordComponent) {
            RecordComponent component = (RecordComponent)annotatedElement;
            return component.getGenericType();
        }
        throw new IllegalStateException("Unable to get the required type from the follow AnnotatedElement: " + annotatedElement.toString());
    }

    public static AnnotatedType getAnnotatedType(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Parameter) {
            Parameter parameter = (Parameter)annotatedElement;
            return parameter.getAnnotatedType();
        }
        if (annotatedElement instanceof Field) {
            Field field = (Field)annotatedElement;
            return field.getAnnotatedType();
        }
        if (annotatedElement instanceof RecordComponent) {
            RecordComponent component = (RecordComponent)annotatedElement;
            return component.getAnnotatedType();
        }
        throw new IllegalStateException("Unable to get the required AnnotatedType from the follow AnnotatedElement: " + annotatedElement.toString());
    }

    public static List<Class<?>> unpackClassStack(Class<?> clazz) {
        ArrayDeque classes = new ArrayDeque();
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.push(superclass);
        }
        classes.offerLast(clazz);
        return List.copyOf(classes);
    }

    public static List<Class<?>> unpackClassesAndInterfaces(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
            classes.addAll(List.of(superclass.getInterfaces()));
        }
        classes.add(clazz);
        return List.copyOf(classes);
    }

    public static ParameterizedType createParameterizedType(final Type rawType, final Type ... typeArguments) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return typeArguments;
            }

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static boolean isIntegerType(Class<?> clazz) {
        return clazz.equals(Byte.TYPE) || clazz.equals(Byte.class) || clazz.equals(Short.TYPE) || clazz.equals(Short.class) || clazz.equals(Integer.TYPE) || clazz.equals(Integer.class) || clazz.equals(Long.TYPE) || clazz.equals(Long.class);
    }

    public static boolean isFloatType(Class<?> clazz) {
        return clazz.equals(Float.TYPE) || clazz.equals(Float.class) || clazz.equals(Double.TYPE) || clazz.equals(Double.class);
    }

    public static boolean isNumber(Class<?> clazz) {
        return ReflectionUtils.isIntegerType(clazz) || ReflectionUtils.isFloatType(clazz);
    }

    public static Number castFloat(Class<?> clazz, double number) {
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return Float.valueOf(((Number)number).floatValue());
        }
        return number;
    }

    public static Number castInteger(Class<?> clazz, long number) {
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return ((Number)number).byteValue();
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return ((Number)number).shortValue();
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return ((Number)number).intValue();
        }
        return number;
    }

    public static boolean areTypesEqual(Type type1, Type type2) {
        if (type1.equals(type2)) {
            return true;
        }
        if (type1.equals(Boolean.TYPE) || type1.equals(Boolean.class)) {
            return type2.equals(Boolean.TYPE) || type2.equals(Boolean.class);
        }
        if (type1.equals(Character.TYPE) || type1.equals(Character.class)) {
            return type2.equals(Character.TYPE) || type2.equals(Character.class);
        }
        if (type1.equals(Byte.TYPE) || type1.equals(Byte.class)) {
            return type2.equals(Byte.TYPE) || type2.equals(Byte.class);
        }
        if (type1.equals(Short.TYPE) || type1.equals(Short.class)) {
            return type2.equals(Short.TYPE) || type2.equals(Short.class);
        }
        if (type1.equals(Integer.TYPE) || type1.equals(Integer.class)) {
            return type2.equals(Integer.TYPE) || type2.equals(Integer.class);
        }
        if (type1.equals(Long.TYPE) || type1.equals(Long.class)) {
            return type2.equals(Long.TYPE) || type2.equals(Long.class);
        }
        if (type1.equals(Float.TYPE) || type1.equals(Float.class)) {
            return type2.equals(Float.TYPE) || type2.equals(Float.class);
        }
        if (type1.equals(Double.TYPE) || type1.equals(Double.class)) {
            return type2.equals(Double.TYPE) || type2.equals(Double.class);
        }
        if (type1.equals(Void.TYPE) || type1.equals(Void.class)) {
            return type2.equals(Void.TYPE) || type2.equals(Void.class);
        }
        if (type1 instanceof ParameterizedType) {
            ParameterizedType parameterizedType1 = (ParameterizedType)type1;
            if (type2 instanceof ParameterizedType) {
                Type[] parameterTypes2;
                Type[] parameterTypes1;
                ParameterizedType parameterizedType2 = (ParameterizedType)type2;
                if (ReflectionUtils.areTypesEqual(parameterizedType1.getRawType(), parameterizedType2.getRawType()) && (parameterTypes1 = parameterizedType1.getActualTypeArguments()).length == (parameterTypes2 = parameterizedType2.getActualTypeArguments()).length) {
                    for (int i = 0; i < parameterTypes1.length; ++i) {
                        Type parameterType1 = parameterTypes1[i];
                        Type parameterType2 = parameterTypes2[i];
                        if (ReflectionUtils.areTypesEqual(parameterType1, parameterType2)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        if (type1 instanceof GenericArrayType) {
            GenericArrayType genericArrayType1 = (GenericArrayType)type1;
            if (type2 instanceof GenericArrayType) {
                GenericArrayType genericArrayType2 = (GenericArrayType)type2;
                return ReflectionUtils.areTypesEqual(genericArrayType1.getGenericComponentType(), genericArrayType2.getGenericComponentType());
            }
        }
        return false;
    }

    public static boolean isTypeCompatible(Type primaryType, Type type) {
        if (primaryType.equals(type)) {
            return true;
        }
        if (primaryType instanceof Class) {
            Class clazz;
            Class primaryClass = (Class)primaryType;
            if (type instanceof Class && primaryClass.isAssignableFrom(clazz = (Class)type)) {
                return true;
            }
        }
        if (primaryType.equals(Boolean.TYPE) || primaryType.equals(Boolean.class)) {
            return type.equals(Boolean.TYPE) || type.equals(Boolean.class);
        }
        if (primaryType.equals(Character.TYPE) || primaryType.equals(Character.class)) {
            return type.equals(Character.TYPE) || type.equals(Character.class);
        }
        if (primaryType.equals(Byte.TYPE) || primaryType.equals(Byte.class)) {
            return type.equals(Byte.TYPE) || type.equals(Byte.class);
        }
        if (primaryType.equals(Short.TYPE) || primaryType.equals(Short.class)) {
            return type.equals(Short.TYPE) || type.equals(Short.class);
        }
        if (primaryType.equals(Integer.TYPE) || primaryType.equals(Integer.class)) {
            return type.equals(Integer.TYPE) || type.equals(Integer.class);
        }
        if (primaryType.equals(Long.TYPE) || primaryType.equals(Long.class)) {
            return type.equals(Long.TYPE) || type.equals(Long.class);
        }
        if (primaryType.equals(Float.TYPE) || primaryType.equals(Float.class)) {
            return type.equals(Float.TYPE) || type.equals(Float.class);
        }
        if (primaryType.equals(Double.TYPE) || primaryType.equals(Double.class)) {
            return type.equals(Double.TYPE) || type.equals(Double.class);
        }
        if (primaryType.equals(Void.TYPE) || primaryType.equals(Void.class)) {
            return type.equals(Void.TYPE) || type.equals(Void.class);
        }
        if (primaryType instanceof ParameterizedType) {
            ParameterizedType primaryParameterizedType = (ParameterizedType)primaryType;
            if (type instanceof ParameterizedType) {
                Type[] parameterTypes2;
                Type[] primaryParameterTypes;
                ParameterizedType parameterizedType2 = (ParameterizedType)type;
                if (ReflectionUtils.isTypeCompatible(primaryParameterizedType.getRawType(), parameterizedType2.getRawType()) && (primaryParameterTypes = primaryParameterizedType.getActualTypeArguments()).length == (parameterTypes2 = parameterizedType2.getActualTypeArguments()).length) {
                    for (int i = 0; i < primaryParameterTypes.length; ++i) {
                        Type primaryParameterType = primaryParameterTypes[i];
                        Type parameterType2 = parameterTypes2[i];
                        if (ReflectionUtils.isTypeCompatible(primaryParameterType, parameterType2)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        if (primaryType instanceof GenericArrayType) {
            GenericArrayType primaryGenericArrayType = (GenericArrayType)primaryType;
            if (type instanceof GenericArrayType) {
                GenericArrayType genericArrayType2 = (GenericArrayType)type;
                return ReflectionUtils.isTypeCompatible(primaryGenericArrayType.getGenericComponentType(), genericArrayType2.getGenericComponentType());
            }
        }
        return false;
    }

    @Nullable
    public static Method getZeroArgMethodWithReturnType(String name, Class<?> clazz, Type returnType, Predicate<Integer> modifierChecks) {
        return ReflectionUtils.getZeroArgMethodWithReturnType(name, clazz, returnType, MethodTypeCheckBypass.FALSE, modifierChecks);
    }

    @Nullable
    public static Method getZeroArgMethodWithReturnType(String name, Class<?> clazz, Type returnType, MethodTypeCheckBypass alternativeTypeCheck, Predicate<Integer> modifierChecks) {
        return ReflectionUtils.getMethodWithPredicate(name, clazz, method -> {
            if (method.getParameterCount() > 0 || !modifierChecks.test(method.getModifiers())) {
                return false;
            }
            Type type = method.getGenericReturnType();
            if (method.getReturnType().equals(Object.class) && alternativeTypeCheck.bypassTypeCheck((Method)method)) {
                return true;
            }
            return ReflectionUtils.areTypesEqual(returnType, type);
        });
    }

    @Nullable
    public static Method getZeroArgMethodWithCompatibleReturnType(String name, Class<?> clazz, Type returnType, Predicate<Integer> modifierChecks) {
        return ReflectionUtils.getZeroArgMethodWithCompatibleReturnType(name, clazz, returnType, MethodTypeCheckBypass.FALSE, modifierChecks);
    }

    @Nullable
    public static Method getZeroArgMethodWithCompatibleReturnType(String name, Class<?> clazz, Type returnType, MethodTypeCheckBypass alternativeTypeCheck, Predicate<Integer> modifierChecks) {
        return ReflectionUtils.getMethodWithPredicate(name, clazz, method -> {
            if (method.getParameterCount() > 0 || !modifierChecks.test(method.getModifiers())) {
                return false;
            }
            Type type = method.getGenericReturnType();
            if (method.getReturnType().equals(Object.class) && alternativeTypeCheck.bypassTypeCheck((Method)method)) {
                return true;
            }
            return ReflectionUtils.isTypeCompatible(returnType, type);
        });
    }

    @Nullable
    private static Method getMethodWithSingleParameterType(String name, Class<?> clazz, Type parameterType, MethodTypeCheckBypass alternativeTypeCheck) {
        ArrayList validReturnTypes = new ArrayList(ReflectionUtils.unpackClassesAndInterfaces(clazz));
        validReturnTypes.add(Void.TYPE);
        return ReflectionUtils.getMethodWithPredicate(name, clazz, method -> {
            Type[] methodParameterTypes;
            if (!Modifier.isStatic(method.getModifiers()) && validReturnTypes.stream().anyMatch(type -> ReflectionUtils.areTypesEqual(type, method.getGenericReturnType())) && (methodParameterTypes = method.getGenericParameterTypes()).length == 1) {
                Type methodParameterType = methodParameterTypes[0];
                if (methodParameterType.equals(Object.class) && alternativeTypeCheck.bypassTypeCheck((Method)method)) {
                    return true;
                }
                return ReflectionUtils.areTypesEqual(methodParameterType, parameterType);
            }
            return false;
        });
    }

    @Nullable
    public static Method getMethodWithPredicate(String name, Class<?> clazz, Predicate<Method> isValid) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || !isValid.test(method)) continue;
            return method;
        }
        return null;
    }

    public static <T> Function<T, Object> createGetter(Class<T> clazz, Field field, MethodTypeCheckBypass alternativeTypeCheck) {
        if (!Modifier.isPublic(field.getModifiers()) && !field.trySetAccessible()) {
            Method method = ReflectionUtils.findGetterMethod(clazz, field, alternativeTypeCheck);
            return t -> {
                try {
                    return method.invoke(t, new Object[0]);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Unable to get field [" + String.valueOf(field) + "] value from method", e);
                }
            };
        }
        return t -> {
            try {
                return field.get(t);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Unable to get field [" + String.valueOf(field) + "] value", e);
            }
        };
    }

    public static <T> BiConsumer<T, Object> createSetter(Class<T> clazz, Field field, MethodTypeCheckBypass alternativeTypeCheck) {
        if (!Modifier.isPublic(field.getModifiers()) && !field.trySetAccessible()) {
            Method method = ReflectionUtils.findSetterMethod(clazz, field, alternativeTypeCheck);
            return (t, o) -> {
                try {
                    method.invoke(t, o);
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Unable to set field value from method", e);
                }
            };
        }
        return (t, o) -> {
            try {
                field.set(t, o);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Unable to set field value", e);
            }
        };
    }

    private static boolean isNotStatic(int modifiers) {
        return !Modifier.isStatic(modifiers);
    }

    private static Method findGetterMethod(Class<?> clazz, Field field, MethodTypeCheckBypass alternativeTypeCheck) {
        String fieldName = field.getName();
        Method method = ReflectionUtils.getZeroArgMethodWithReturnType(fieldName, clazz, field.getType(), alternativeTypeCheck, ReflectionUtils::isNotStatic);
        if (method == null) {
            String getterName = "get" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
            method = ReflectionUtils.getZeroArgMethodWithReturnType(getterName, clazz, field.getType(), alternativeTypeCheck, ReflectionUtils::isNotStatic);
        }
        if (method == null) {
            throw new IllegalStateException("Unable to get the needed getter for the following private field [" + fieldName + "] for class [" + String.valueOf(clazz) + "]");
        }
        return method;
    }

    private static Method findSetterMethod(Class<?> clazz, Field field, MethodTypeCheckBypass alternativeTypeCheck) {
        String fieldName = field.getName();
        Method method = ReflectionUtils.getMethodWithSingleParameterType(fieldName, clazz, field.getType(), alternativeTypeCheck);
        if (method == null) {
            String setterName = "set" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
            method = ReflectionUtils.getMethodWithSingleParameterType(setterName, clazz, field.getType(), alternativeTypeCheck);
        }
        if (method == null) {
            throw new IllegalStateException("Unable to get the needed setter for the following private field [" + fieldName + "] for class [" + String.valueOf(clazz) + "]");
        }
        return method;
    }

    public static interface AlternativeTypeGetter {
        public Optional<Type> getAlternativeType(Method var1);
    }
}

