/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.util;

import it.unimi.dsi.fastutil.bytes.ByteConsumer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VarInts {
    public static final int SEGMENT_BITS = 127;
    public static final int CONTINUE_BIT = 128;

    public static int getSizeInBytesFromInt(int i) {
        for (int j = 1; j < 5; ++j) {
            if ((i & -1 << j * 7) != 0) continue;
            return j;
        }
        return 5;
    }

    public static int getSizeInBytesFromLong(long l) {
        for (int i = 1; i < 10; ++i) {
            if ((l & -1L << i * 7) != 0L) continue;
            return i;
        }
        return 10;
    }

    public static int readInt(ByteSupplier readByteSup) {
        int value;
        block1: {
            value = 0;
            int position = 0;
            do {
                byte currentByte = readByteSup.get();
                value |= (currentByte & 0x7F) << position;
                if ((currentByte & 0x80) == 0) break block1;
            } while ((position += 7) < 32);
            throw new RuntimeException("VarInt is too big");
        }
        return value;
    }

    public static void writeInt(int value, ByteConsumer writeByteFunc) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                writeByteFunc.accept((byte)value);
                return;
            }
            writeByteFunc.accept((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    public static long readLong(ByteSupplier readByteSup) {
        long value;
        block1: {
            value = 0L;
            int position = 0;
            do {
                byte currentByte = readByteSup.get();
                value |= (long)(currentByte & 0x7F) << position;
                if ((currentByte & 0x80) == 0) break block1;
            } while ((position += 7) < 64);
            throw new RuntimeException("VarLong is too big");
        }
        return value;
    }

    public static void writeLong(long value, ByteConsumer writeByteFunc) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                writeByteFunc.accept((byte)value);
                return;
            }
            writeByteFunc.accept((byte)(value & 0x7FL | 0x80L));
            value >>>= 7;
        }
    }

    public static interface ByteSupplier {
        public byte get();
    }
}

