/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.util;

import io.wispforest.endec.Serializer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;

public abstract class RecursiveSerializer<T>
implements Serializer<T> {
    protected final Deque<Consumer<T>> frames = new ArrayDeque<Consumer<T>>();
    protected T result;

    protected RecursiveSerializer(T initialResult) {
        this.result = initialResult;
        this.frames.push(t -> {
            this.result = t;
        });
    }

    protected void consume(T value) {
        this.frames.peek().accept(value);
    }

    protected void frame(FrameAction<T> action) {
        EncodedValue encoded = new EncodedValue();
        this.frames.push(encoded::set);
        action.accept(encoded);
        this.frames.pop();
    }

    @Override
    public T result() {
        return this.result;
    }

    protected static class EncodedValue<T> {
        private T value = null;
        private boolean encoded = false;

        protected EncodedValue() {
        }

        private void set(T value) {
            this.value = value;
            this.encoded = true;
        }

        public T value() {
            return this.value;
        }

        public boolean wasEncoded() {
            return this.encoded;
        }

        public T require(String name) {
            if (!this.encoded) {
                throw new IllegalStateException("Endec for " + name + " serialized nothing");
            }
            return this.value();
        }
    }

    @FunctionalInterface
    protected static interface FrameAction<T> {
        public void accept(EncodedValue<T> var1);
    }
}

