/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.util;

import io.wispforest.endec.Deserializer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class RecursiveDeserializer<T>
implements Deserializer<T> {
    protected final Deque<Supplier<T>> frames = new ArrayDeque<Supplier<T>>();
    protected final T serialized;

    protected RecursiveDeserializer(T serialized) {
        this.serialized = serialized;
        this.frames.push(() -> this.serialized);
    }

    protected T getValue() {
        return this.frames.peek().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V frame(Supplier<T> nextValue, Supplier<V> action) {
        try {
            this.frames.push(nextValue);
            V v = action.get();
            return v;
        }
        finally {
            this.frames.pop();
        }
    }

    @Override
    public <V> V tryRead(Function<Deserializer<T>, V> reader) {
        ArrayDeque<Supplier<T>> framesBackup = new ArrayDeque<Supplier<T>>(this.frames);
        try {
            return reader.apply(this);
        }
        catch (Exception e) {
            this.frames.clear();
            this.frames.addAll(framesBackup);
            throw e;
        }
    }

    protected record Frame<T>(Supplier<T> source, boolean isStructField) {
    }
}

