/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.util;

import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import io.wispforest.endec.util.MapCarrierEncodable;
import org.jetbrains.annotations.NotNull;

public interface MapCarrierDecodable {
    default public <T> T getWithErrors(SerializationContext ctx, @NotNull KeyedEndec<T> key) {
        throw new UnsupportedOperationException("Interface default method called");
    }

    default public <T> T getWithErrors(@NotNull KeyedEndec<T> key) {
        return this.getWithErrors(SerializationContext.empty(), key);
    }

    default public <T> T get(SerializationContext ctx, @NotNull KeyedEndec<T> key) {
        try {
            return this.getWithErrors(ctx, key);
        }
        catch (Exception e) {
            return key.defaultValue();
        }
    }

    default public <T> T get(@NotNull KeyedEndec<T> key) {
        return this.get(SerializationContext.empty(), key);
    }

    default public <T> boolean has(@NotNull KeyedEndec<T> key) {
        throw new UnsupportedOperationException("Interface default method called");
    }

    default public <T> void copy(@NotNull KeyedEndec<T> key, @NotNull MapCarrierEncodable other) {
        this.copy(SerializationContext.empty(), key, other);
    }

    default public <T> void copy(SerializationContext ctx, @NotNull KeyedEndec<T> key, @NotNull MapCarrierEncodable other) {
        other.put(ctx, key, this.get(ctx, key));
    }

    default public <T> void copyIfPresent(@NotNull KeyedEndec<T> key, @NotNull MapCarrierEncodable other) {
        this.copyIfPresent(SerializationContext.empty(), key, other);
    }

    default public <T> void copyIfPresent(SerializationContext ctx, @NotNull KeyedEndec<T> key, @NotNull MapCarrierEncodable other) {
        if (!this.has(key)) {
            return;
        }
        this.copy(ctx, key, other);
    }

    @Deprecated(forRemoval=true)
    default public <T> void copyIfPresent(@NotNull KeyedEndec<T> key, SerializationContext ctx, @NotNull MapCarrier other) {
        this.copyIfPresent(ctx, key, (MapCarrierEncodable)other);
    }
}

