/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.impl;

import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttributes;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.annotations.Comment;
import io.wispforest.endec.annotations.DefinedEndecGetter;
import io.wispforest.endec.annotations.GenericTypeCheckBypass;
import io.wispforest.endec.annotations.IsNullable;
import io.wispforest.endec.annotations.IsVarInt;
import io.wispforest.endec.annotations.NullableComponent;
import io.wispforest.endec.annotations.RangedFloat;
import io.wispforest.endec.annotations.RangedInteger;
import io.wispforest.endec.annotations.SealedPolymorphic;
import io.wispforest.endec.impl.BuiltInEndecs;
import io.wispforest.endec.impl.CommentAttribute;
import io.wispforest.endec.impl.ObjectEndec;
import io.wispforest.endec.impl.OptionalEndec;
import io.wispforest.endec.impl.RecordEndec;
import io.wispforest.endec.util.reflection.AdjustmentResult;
import io.wispforest.endec.util.reflection.AnnotatedAdjuster;
import io.wispforest.endec.util.reflection.AnnotatedContextGatherer;
import io.wispforest.endec.util.reflection.MethodTypeCheckBypass;
import io.wispforest.endec.util.reflection.ReflectionUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ReflectiveEndecBuilder {
    public static final ReflectiveEndecBuilder SHARED_INSTANCE = new ReflectiveEndecBuilder();
    private final Map<Class<?>, Endec<?>> classToEndec = new LinkedHashMap();
    private final Map<Class<? extends Annotation>, AnnotatedContextGatherer<? extends Annotation>> classToContextGatherer = new LinkedHashMap<Class<? extends Annotation>, AnnotatedContextGatherer<? extends Annotation>>();
    private final Map<Class<? extends Annotation>, AnnotatedAdjuster<? extends Annotation>> classToTypeAdjuster = new LinkedHashMap<Class<? extends Annotation>, AnnotatedAdjuster<? extends Annotation>>();
    private final Map<Class<?>, MethodTypeCheckBypass> classToAlternativeChecker = new LinkedHashMap();

    public ReflectiveEndecBuilder(Consumer<ReflectiveEndecBuilder> defaultsSetup) {
        defaultsSetup.accept(this);
        ReflectiveEndecBuilder.registerDefaults(this);
    }

    public ReflectiveEndecBuilder() {
        this(reflectiveEndecBuilder -> {});
    }

    public <T> ReflectiveEndecBuilder register(Endec<T> endec, Class<T> clazz) {
        if (this.classToEndec.containsKey(clazz)) {
            throw new IllegalStateException("Class '" + clazz.getName() + "' already has an associated endec");
        }
        this.classToEndec.put(clazz, endec);
        return this;
    }

    @SafeVarargs
    public final <T> ReflectiveEndecBuilder register(Endec<T> endec, Class<T> ... classes) {
        for (Class<T> clazz : classes) {
            this.register(endec, clazz);
        }
        return this;
    }

    public <A extends Annotation> ReflectiveEndecBuilder registerTypeAdjuster(Class<A> clazz, AnnotatedAdjuster<A> adjuster) {
        if (this.classToTypeAdjuster.containsKey(clazz)) {
            throw new IllegalStateException("Class '" + clazz.getName() + "' already has an associated AnnotatedAdjuster");
        }
        this.classToTypeAdjuster.put(clazz, adjuster);
        return this;
    }

    public <A extends Annotation> ReflectiveEndecBuilder registerContextGatherer(Class<A> clazz, AnnotatedContextGatherer<A> adjuster) {
        if (this.classToContextGatherer.containsKey(clazz)) {
            throw new IllegalStateException("Class '" + clazz.getName() + "' already has an associated AnnotatedContextGatherer");
        }
        this.classToContextGatherer.put(clazz, adjuster);
        return this;
    }

    public ReflectiveEndecBuilder registerMethodTypeCheckBypass(Class<?> clazz, String ... methodNames) {
        Set<String> validMethodsToBypass = Set.of(methodNames);
        return this.registerMethodTypeCheckBypass(clazz, (Method method) -> validMethodsToBypass.contains(method.getName()));
    }

    public ReflectiveEndecBuilder registerMethodTypeCheckBypass(Class<?> clazz, MethodTypeCheckBypass restorer) {
        if (this.classToAlternativeChecker.containsKey(clazz)) {
            throw new IllegalStateException("Class '" + clazz.getName() + "' already has an associated GenericRestorer");
        }
        this.classToAlternativeChecker.put(clazz, restorer);
        return this;
    }

    public SerializationContext getContext(AnnotatedElement annotatedElement) {
        return this.getContext(ReflectionUtils.getAnnotatedType(annotatedElement));
    }

    private SerializationContext getContext(AnnotatedType annotatedType) {
        SerializationContext context = SerializationContext.empty();
        for (Class<? extends Annotation> clazz : this.classToContextGatherer.keySet()) {
            context = context.and(this.getContextFromType(clazz, annotatedType));
        }
        return context;
    }

    private <A extends Annotation> SerializationContext getContextFromType(Class<A> annotationClazz, AnnotatedType annotatedType) {
        if (!annotatedType.isAnnotationPresent(annotationClazz)) {
            return SerializationContext.empty();
        }
        return this.classToContextGatherer.get(annotationClazz).getContext(annotatedType, (Annotation)annotatedType.getAnnotation(annotationClazz));
    }

    MethodTypeCheckBypass getAlternativeGenericTypeCheck(Class<?> clazz) {
        MethodTypeCheckBypass alternativeCheck = this.classToAlternativeChecker.get(clazz);
        if (alternativeCheck != null) {
            return alternativeCheck;
        }
        if (clazz.isAnnotationPresent(GenericTypeCheckBypass.class)) {
            Set<String> validMethodsToBypass = Set.of(clazz.getAnnotation(GenericTypeCheckBypass.class).methodsToBypass());
            return method -> validMethodsToBypass.contains(method.getName());
        }
        return MethodTypeCheckBypass.FALSE;
    }

    public Endec<?> getAnnotated(AnnotatedElement annotatedElement) {
        return this.getAnnotated(annotatedElement, ReflectionUtils.getBaseType(annotatedElement));
    }

    public Endec<?> getAnnotated(AnnotatedElement annotatedElement, @Nullable Type baseType) {
        RecordComponent component;
        Endec<?> endec = this.getAnnotated(ReflectionUtils.getAnnotatedType(annotatedElement), baseType);
        if (annotatedElement instanceof RecordComponent && (component = (RecordComponent)annotatedElement).isAnnotationPresent(NullableComponent.class)) {
            endec = endec.nullableOf();
        }
        return endec;
    }

    public Endec<?> getAnnotated(AnnotatedType annotatedType) {
        return this.getAnnotated(annotatedType, null);
    }

    public Endec<?> getAnnotated(AnnotatedType annotatedType, @Nullable Type baseType) {
        Type type = baseType == null ? annotatedType.getType() : baseType;
        Endec<Object> endec = null;
        if (annotatedType instanceof AnnotatedArrayType) {
            AnnotatedArrayType annotatedArrayType = (AnnotatedArrayType)annotatedType;
            Class arrayClazz = (Class)(type instanceof GenericArrayType ? baseType : type);
            if (arrayClazz == null) {
                throw new IllegalStateException("Unable to get the required base Array class to get the component type!");
            }
            endec = this.createArrayEndec((Class<?>)arrayClazz.componentType(), annotatedArrayType.getAnnotatedGenericComponentType());
        } else if (type instanceof Class) {
            Class clazz = (Class)type;
            endec = this.getOrNull(clazz);
        } else if (annotatedType instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType[] annotatedTypeArgs = annotatedParameterizedType.getAnnotatedActualTypeArguments();
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getRawType();
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                endec = clazz.equals(Map.class) ? (annotatedTypeArgs[0].getType() == String.class ? this.getAnnotated(annotatedTypeArgs[1]).mapOf() : Endec.map(this.getAnnotated(annotatedTypeArgs[0]), this.getAnnotated(annotatedTypeArgs[1]))) : (clazz.equals(List.class) ? this.getAnnotated(annotatedTypeArgs[0]).listOf() : (clazz.equals(Set.class) ? this.getAnnotated(annotatedTypeArgs[0]).setOf() : (clazz.equals(Optional.class) ? this.getAnnotated(annotatedTypeArgs[0]).optionalOf() : (ReflectiveEndecBuilder.isGenericObject(clazz) ? ObjectEndec.create(this, clazz, type) : this.getOrNull(clazz)))));
            }
        }
        if (endec == null) {
            throw new IllegalStateException("No Endec available for the given type '" + String.valueOf(type) + "'");
        }
        endec = this.adjustEndecWithType(annotatedType, endec);
        return endec;
    }

    private <T> Endec<T> adjustEndecWithType(AnnotatedType annotatedType, Endec<T> endec) {
        for (Class<? extends Annotation> clazz : this.classToTypeAdjuster.keySet()) {
            AdjustmentResult<T> results = this.applyAdjusterIfPresent(clazz, annotatedType, endec);
            if (!results.allowFutherAdjustments()) {
                return results.endec();
            }
            if (results.equals(AdjustmentResult.empty())) continue;
            endec = results.endec();
        }
        return endec;
    }

    private <A extends Annotation, T> AdjustmentResult<T> applyAdjusterIfPresent(Class<A> annotationClazz, AnnotatedType annotatedType, Endec<T> endec) {
        if (!annotatedType.isAnnotationPresent(annotationClazz)) {
            return AdjustmentResult.empty();
        }
        return this.classToTypeAdjuster.get(annotationClazz).adjustEndec(annotatedType, (Annotation)annotatedType.getAnnotation(annotationClazz), endec);
    }

    public Endec<?> get(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return this.get(clazz);
        }
        if (type instanceof AnnotatedElement) {
            AnnotatedElement annotatedElement = (AnnotatedElement)((Object)type);
            return this.getAnnotated(annotatedElement);
        }
        ParameterizedType parameterized = (ParameterizedType)type;
        Class raw = (Class)parameterized.getRawType();
        Type[] typeArgs = parameterized.getActualTypeArguments();
        if (raw == Map.class) {
            return typeArgs[0] == String.class ? this.get(typeArgs[1]).mapOf() : Endec.map(this.get(typeArgs[0]), this.get(typeArgs[1]));
        }
        if (raw == List.class) {
            return this.get(typeArgs[0]).listOf();
        }
        if (raw == Set.class) {
            return this.get(typeArgs[0]).listOf().xmap(list -> new HashSet(list), set -> List.copyOf(set));
        }
        if (raw == Optional.class) {
            return this.get(typeArgs[0]).optionalOf();
        }
        if (Record.class.isAssignableFrom(raw)) {
            return RecordEndec.create(this, raw, typeArgs);
        }
        if (ReflectiveEndecBuilder.isGenericObject(raw)) {
            return ObjectEndec.create(this, raw, typeArgs);
        }
        return this.get(raw);
    }

    private static boolean isGenericObject(Class<?> clazz) {
        return !Record.class.isAssignableFrom(clazz) && !clazz.isEnum() && !clazz.isArray() && !clazz.isAnnotationPresent(SealedPolymorphic.class);
    }

    public <T> Endec<T> get(Class<T> clazz) {
        Endec<T> endec = this.getOrNull(clazz);
        if (endec == null) {
            throw new IllegalStateException("No endec available for class '" + clazz.getName() + "'");
        }
        return endec;
    }

    public <T> Optional<Endec<T>> maybeGet(Class<T> clazz) {
        return Optional.ofNullable(this.getOrNull(clazz));
    }

    @Nullable
    private <T> Endec<T> getOrNull(Class<T> clazz) {
        Endec<Object> endec = this.classToEndec.get(clazz);
        if (endec != null) {
            return endec;
        }
        endec = this.getDefinedEndec(clazz);
        if (endec == null) {
            endec = Record.class.isAssignableFrom(clazz) ? RecordEndec.create(this, clazz) : (clazz.isEnum() ? Endec.forEnum(clazz) : (clazz.isArray() ? this.createArrayEndec(clazz.getComponentType(), null) : (clazz.isAnnotationPresent(SealedPolymorphic.class) ? this.createSealedEndec(clazz) : ObjectEndec.create(this, clazz))));
        }
        this.classToEndec.put(clazz, endec);
        return endec;
    }

    <T> Endec<T> getExistingEndec(Class<T> clazz) {
        return this.classToEndec.get(clazz);
    }

    private Endec<?> getDefinedEndec(Class<?> clazz) {
        List<Field> possibleEndecGetterFields = Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(DefinedEndecGetter.class)).toList();
        List<Method> possibleEndecGetterMethods = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers())).filter(method -> method.isAnnotationPresent(DefinedEndecGetter.class)).toList();
        if (possibleEndecGetterFields.size() > 1) {
            throw new IllegalStateException("Multiple DefinedEndecGetter fields within the given class: " + String.valueOf(clazz));
        }
        if (possibleEndecGetterMethods.size() > 1) {
            throw new IllegalStateException("Multiple DefinedEndecGetter methods within the given class: " + String.valueOf(clazz));
        }
        if (!possibleEndecGetterFields.isEmpty()) {
            Field field2 = possibleEndecGetterFields.get(0);
            int modifiers = field2.getModifiers();
            if (!Modifier.isStatic(modifiers) && !Modifier.isPublic(modifiers)) {
                throw new IllegalStateException("A DefinedEndecGetter field was found not be PUBLIC and/or STATIC which is required!");
            }
            boolean isEndec = ReflectionUtils.isTypeCompatible(ReflectionUtils.createParameterizedType(Endec.class, new Type[]{clazz}), field2.getGenericType());
            boolean isStructEndec = ReflectionUtils.isTypeCompatible(ReflectionUtils.createParameterizedType(StructEndec.class, new Type[]{clazz}), field2.getGenericType());
            if (!isEndec && !isStructEndec) {
                throw new IllegalStateException("Unable to use the given field [" + String.valueOf(field2) + "] due to the type not matching the following class: " + String.valueOf(clazz));
            }
            try {
                return (Endec)field2.get(null);
            }
            catch (Throwable e) {
                throw new RuntimeException("A clazz [" + String.valueOf(clazz) + "] with a Defined Endec field was unable to be gotten due to an error!", e);
            }
        }
        if (!possibleEndecGetterMethods.isEmpty()) {
            Method method2 = possibleEndecGetterMethods.get(0);
            int modifiers = method2.getModifiers();
            if (!Modifier.isStatic(modifiers) && !Modifier.isPublic(modifiers)) {
                throw new IllegalStateException("A DefinedEndecGetter method was found not be PUBLIC and/or STATIC which is required!");
            }
            boolean isEndec = ReflectionUtils.isTypeCompatible(ReflectionUtils.createParameterizedType(Endec.class, new Type[]{clazz}), method2.getGenericReturnType());
            boolean isStructEndec = ReflectionUtils.isTypeCompatible(ReflectionUtils.createParameterizedType(StructEndec.class, new Type[]{clazz}), method2.getGenericReturnType());
            if (!isEndec && !isStructEndec) {
                throw new IllegalStateException("Unable to use the given field [" + String.valueOf(method2) + "] due to the type not matching the following class: " + String.valueOf(clazz));
            }
            try {
                return (Endec)method2.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                throw new RuntimeException("A clazz [" + String.valueOf(clazz) + "] with a Defined Endec field was unable to be gotten due to an error!", e);
            }
        }
        return null;
    }

    private Endec<?> createArrayEndec(Class<?> elementClass, @Nullable AnnotatedType genericComponentType) {
        if (elementClass.equals(Byte.TYPE) || elementClass.equals(Byte.class)) {
            return Endec.BYTES;
        }
        Endec<?> elementEndec = genericComponentType == null ? this.get(elementClass) : this.getAnnotated(genericComponentType);
        return elementEndec.listOf().xmap(list -> {
            int length = list.size();
            Object array = Array.newInstance(elementClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }, t -> {
            int length = Array.getLength(t);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(t, i));
            }
            return list;
        });
    }

    private Endec<?> createSealedEndec(Class<?> commonClass) {
        if (!commonClass.isSealed()) {
            throw new IllegalStateException("@SealedPolymorphic class must be sealed");
        }
        List permittedSubclasses = Arrays.stream(commonClass.getPermittedSubclasses()).collect(Collectors.toList());
        for (int i = 0; i < permittedSubclasses.size(); ++i) {
            Class clazz = (Class)permittedSubclasses.get(i);
            if (!clazz.isSealed()) continue;
            for (Class<?> subclass : clazz.getPermittedSubclasses()) {
                if (permittedSubclasses.contains(subclass)) continue;
                permittedSubclasses.add(subclass);
            }
        }
        for (Class clazz : permittedSubclasses) {
            if (clazz.isSealed() || Modifier.isFinal(clazz.getModifiers())) continue;
            throw new IllegalStateException("Subclasses of a @SealedPolymorphic class must themselves be sealed");
        }
        permittedSubclasses.sort(Comparator.comparing(Class::getName));
        Int2ObjectOpenHashMap serializerMap = new Int2ObjectOpenHashMap();
        Reference2IntOpenHashMap classesMap = new Reference2IntOpenHashMap();
        Object2IntOpenHashMap namedMap = new Object2IntOpenHashMap();
        classesMap.defaultReturnValue(-1);
        for (int i = 0; i < permittedSubclasses.size(); ++i) {
            Class klass = (Class)permittedSubclasses.get(i);
            serializerMap.put(i, this.get(klass));
            classesMap.put((Object)klass, i);
            if (namedMap.containsKey((Object)klass.getSimpleName())) {
                int existingIndex = namedMap.getInt((Object)klass.getSimpleName());
                Class existingKlass = null;
                for (Reference2IntMap.Entry classEntry : classesMap.reference2IntEntrySet()) {
                    if (classEntry.getIntValue() != existingIndex) continue;
                    existingKlass = (Class)classEntry.getKey();
                    break;
                }
                throw new IllegalStateException("Unable to handled the given set of sealed class as two or more class share the same name! [Class1: " + existingKlass.getName() + ", Class2: " + klass.getName() + "]");
            }
            namedMap.put((Object)klass.getSimpleName(), i);
        }
        return Endec.ifAttr(SerializationAttributes.HUMAN_READABLE, Endec.dispatched(name -> (Endec)serializerMap.get(namedMap.getInt(name)), instance -> instance.getClass().getName(), Endec.STRING)).orElse(Endec.dispatched(integer -> (Endec)serializerMap.get(integer.intValue()), instance -> classesMap.getInt(instance.getClass()), Endec.INT));
    }

    @SafeVarargs
    private <T> ReflectiveEndecBuilder registerIfMissing(Endec<T> endec, Class<T> ... classes) {
        for (Class<T> clazz : classes) {
            this.classToEndec.putIfAbsent(clazz, endec);
        }
        return this;
    }

    private static void registerDefaults(ReflectiveEndecBuilder builder) {
        builder.registerIfMissing(Endec.BOOLEAN, Boolean.class, Boolean.TYPE).registerIfMissing(Endec.INT, Integer.class, Integer.TYPE).registerIfMissing(Endec.LONG, Long.class, Long.TYPE).registerIfMissing(Endec.FLOAT, Float.class, Float.TYPE).registerIfMissing(Endec.DOUBLE, Double.class, Double.TYPE);
        builder.registerIfMissing(Endec.BYTE, Byte.class, Byte.TYPE).registerIfMissing(Endec.SHORT, Short.class, Short.TYPE).registerIfMissing(Endec.SHORT.xmap(aShort -> Character.valueOf((char)aShort.shortValue()), character -> (short)character.charValue()), Character.class, Character.TYPE);
        builder.registerIfMissing(Endec.VOID, Void.class);
        builder.registerIfMissing(Endec.STRING, String.class).registerIfMissing(BuiltInEndecs.UUID, UUID.class).registerIfMissing(BuiltInEndecs.DATE, Date.class).registerIfMissing(BuiltInEndecs.BITSET, BitSet.class);
        builder.registerTypeAdjuster(IsNullable.class, new AnnotatedAdjuster<IsNullable>(){

            @Override
            public <T> AdjustmentResult<T> adjustEndec(AnnotatedType annotatedType, IsNullable annotation, Endec<T> base) {
                return AdjustmentResult.of(new OptionalEndec<Object>(base.optionalOf(), () -> null, annotation.mayOmitField()));
            }
        });
        builder.registerTypeAdjuster(IsVarInt.class, new AnnotatedAdjuster<IsVarInt>(){

            @Override
            public <T> AdjustmentResult<T> adjustEndec(AnnotatedType annotatedType, IsVarInt annotation, Endec<T> base) {
                Type type = annotatedType.getType();
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
                        return AdjustmentResult.of(Endec.VAR_INT);
                    }
                    if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
                        return AdjustmentResult.of(Endec.VAR_LONG);
                    }
                }
                return AdjustmentResult.empty();
            }
        });
        builder.registerTypeAdjuster(RangedFloat.class, new AnnotatedAdjuster<RangedFloat>(){

            @Override
            public <T> AdjustmentResult<T> adjustEndec(AnnotatedType annotatedType, RangedFloat annotation, Endec<T> base) {
                Type type = annotatedType.getType();
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    if (ReflectionUtils.isIntegerType(clazz)) {
                        throw new IllegalStateException("Can not apply RangedFloat to a integer type, use RangedInteger instead!");
                    }
                    if (ReflectionUtils.isFloatType(clazz)) {
                        return AdjustmentResult.of(ReflectiveEndecBuilder.rangedUnsafe(base, ReflectionUtils.castFloat(clazz, annotation.min()), ReflectionUtils.castFloat(clazz, annotation.max()), annotation.throwError()));
                    }
                }
                return AdjustmentResult.empty();
            }
        });
        builder.registerTypeAdjuster(RangedInteger.class, new AnnotatedAdjuster<RangedInteger>(){

            @Override
            public <T> AdjustmentResult<T> adjustEndec(AnnotatedType annotatedType, RangedInteger annotation, Endec<T> base) {
                Type type = annotatedType.getType();
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    if (ReflectionUtils.isFloatType(clazz)) {
                        throw new IllegalStateException("Can not apply RangedInteger to a integer type, use RangedFloat instead!");
                    }
                    if (ReflectionUtils.isIntegerType(clazz)) {
                        return AdjustmentResult.of(ReflectiveEndecBuilder.rangedUnsafe(base, ReflectionUtils.castInteger(clazz, annotation.min()), ReflectionUtils.castInteger(clazz, annotation.max()), annotation.throwError()));
                    }
                }
                return AdjustmentResult.empty();
            }
        });
        builder.registerContextGatherer(Comment.class, (annotatedType, annotation) -> SerializationContext.attributes(new CommentAttribute(annotation.comment())));
    }

    private static <N extends Number> Endec<N> rangedUnsafe(Endec<?> endec, @Nullable Number min, @Nullable Number max, boolean throwError) {
        return Endec.ranged(endec, min, max, throwError);
    }
}

