/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.impl;

import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.RecordishEndec;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RecordEndec<R extends Record>
extends RecordishEndec<R> {
    private static final Map<Class<?>, RecordEndec<?>> ENDECS = new HashMap();

    private RecordEndec(Constructor<R> instanceCreator, List<StructField<R, ?>> fields) {
        super(instanceCreator, fields);
    }

    public static <R extends Record> RecordEndec<R> createShared(Class<R> recordClass) {
        return RecordEndec.create(ReflectiveEndecBuilder.SHARED_INSTANCE, recordClass);
    }

    public static <R extends Record> RecordEndec<R> create(ReflectiveEndecBuilder builder, Class<R> recordClass) {
        return RecordEndec.create(builder, recordClass, new Type[0]);
    }

    public static <R extends Record> RecordEndec<R> create(ReflectiveEndecBuilder builder, Class<R> recordClass, Type ... typeArguments) {
        ArrayDeque<Type> extraTypeInfoStack = new ArrayDeque<Type>(List.of(typeArguments));
        Endec<R> endec = builder.getExistingEndec(recordClass);
        if (endec instanceof RecordEndec) {
            RecordEndec recordEndec = (RecordEndec)endec;
            return recordEndec;
        }
        ArrayList fields = new ArrayList();
        Class[] canonicalConstructorArgs = new Class[recordClass.getRecordComponents().length];
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        for (int i = 0; i < recordClass.getRecordComponents().length; ++i) {
            try {
                RecordComponent component = recordClass.getRecordComponents()[i];
                MethodHandle handle = lookup.unreflect(component.getAccessor());
                Type type = component.getGenericType() instanceof TypeVariable ? extraTypeInfoStack.poll() : null;
                fields.add(new StructField<Record, Object>(component.getName(), builder.getAnnotated(component, type), instance -> RecordEndec.getRecordEntry(instance, handle), null, builder.getContext(component)));
                canonicalConstructorArgs[i] = component.getType();
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to create method handle for record component accessor", e);
            }
        }
        try {
            return new RecordEndec<R>(recordClass.getConstructor(canonicalConstructorArgs), fields);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not locate canonical record constructor");
        }
    }

    private static <R extends Record> Object getRecordEntry(R instance, MethodHandle accessor) {
        try {
            return accessor.invoke(instance);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to get record component value", e);
        }
    }
}

