/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.impl;

import io.wispforest.endec.Deserializer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import java.util.LinkedHashMap;
import java.util.Map;

public class AttributeStructEndecBuilder<T> {
    private final Map<SerializationAttribute, StructEndec<T>> branches = new LinkedHashMap<SerializationAttribute, StructEndec<T>>();

    public AttributeStructEndecBuilder(StructEndec<T> endec, SerializationAttribute attribute) {
        this.branches.put(attribute, endec);
    }

    public AttributeStructEndecBuilder<T> orElseIf(StructEndec<T> endec, SerializationAttribute attribute) {
        return this.orElseIf(attribute, endec);
    }

    public AttributeStructEndecBuilder<T> orElseIf(SerializationAttribute attribute, StructEndec<T> endec) {
        if (this.branches.containsKey(attribute)) {
            throw new IllegalStateException("Cannot have more than one branch for attribute " + attribute.name);
        }
        this.branches.put(attribute, endec);
        return this;
    }

    public StructEndec<T> orElse(final StructEndec<T> endec) {
        return new StructEndec<T>(){

            @Override
            public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) {
                StructEndec branchEndec = endec;
                for (Map.Entry branch : AttributeStructEndecBuilder.this.branches.entrySet()) {
                    if (!ctx.hasAttribute(branch.getKey())) continue;
                    branchEndec = branch.getValue();
                    break;
                }
                branchEndec.encodeStruct(ctx, serializer, struct, value);
            }

            @Override
            public T decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
                StructEndec branchEndec = endec;
                for (Map.Entry branch : AttributeStructEndecBuilder.this.branches.entrySet()) {
                    if (!ctx.hasAttribute(branch.getKey())) continue;
                    branchEndec = branch.getValue();
                    break;
                }
                return branchEndec.decodeStruct(ctx, deserializer, struct);
            }
        };
    }
}

