/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.impl;

import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import java.util.LinkedHashMap;
import java.util.Map;

public class AttributeEndecBuilder<T> {
    private final Map<SerializationAttribute, Endec<T>> branches = new LinkedHashMap<SerializationAttribute, Endec<T>>();

    public AttributeEndecBuilder(Endec<T> endec, SerializationAttribute attribute) {
        this.branches.put(attribute, endec);
    }

    public AttributeEndecBuilder<T> orElseIf(Endec<T> endec, SerializationAttribute attribute) {
        return this.orElseIf(attribute, endec);
    }

    public AttributeEndecBuilder<T> orElseIf(SerializationAttribute attribute, Endec<T> endec) {
        if (this.branches.containsKey(attribute)) {
            throw new IllegalStateException("Cannot have more than one branch for attribute " + attribute.name);
        }
        this.branches.put(attribute, endec);
        return this;
    }

    public Endec<T> orElse(final Endec<T> endec) {
        return new Endec<T>(){

            @Override
            public void encode(SerializationContext ctx, Serializer<?> serializer, T value) {
                Endec branchEndec = endec;
                for (Map.Entry branch : AttributeEndecBuilder.this.branches.entrySet()) {
                    if (!ctx.hasAttribute(branch.getKey())) continue;
                    branchEndec = branch.getValue();
                    break;
                }
                branchEndec.encode(ctx, serializer, value);
            }

            @Override
            public T decode(SerializationContext ctx, Deserializer<?> deserializer) {
                Endec branchEndec = endec;
                for (Map.Entry branch : AttributeEndecBuilder.this.branches.entrySet()) {
                    if (!ctx.hasAttribute(branch.getKey())) continue;
                    branchEndec = branch.getValue();
                    break;
                }
                return branchEndec.decode(ctx, deserializer);
            }
        };
    }
}

