/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.java;

import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.util.RecursiveDeserializer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class JavaDeserializer
extends RecursiveDeserializer<Object>
implements SelfDescribedDeserializer<Object> {
    protected JavaDeserializer(Object serialized) {
        super(serialized);
    }

    public static JavaDeserializer of(Object serialized) {
        return new JavaDeserializer(serialized);
    }

    @Override
    public byte readByte(SerializationContext ctx) {
        return this.getAndCast(Byte.TYPE);
    }

    @Override
    public short readShort(SerializationContext ctx) {
        return this.getAndCast(Short.TYPE);
    }

    @Override
    public int readInt(SerializationContext ctx) {
        return this.getAndCast(Integer.TYPE);
    }

    @Override
    public long readLong(SerializationContext ctx) {
        return this.getAndCast(Long.TYPE);
    }

    @Override
    public float readFloat(SerializationContext ctx) {
        return this.getAndCast(Float.TYPE).floatValue();
    }

    @Override
    public double readDouble(SerializationContext ctx) {
        return this.getAndCast(Double.TYPE);
    }

    @Override
    public int readVarInt(SerializationContext ctx) {
        return this.readInt(ctx);
    }

    @Override
    public long readVarLong(SerializationContext ctx) {
        return this.readLong(ctx);
    }

    @Override
    public boolean readBoolean(SerializationContext ctx) {
        return this.getAndCast(Boolean.TYPE);
    }

    @Override
    public String readString(SerializationContext ctx) {
        return this.getAndCast(String.class);
    }

    @Override
    public byte[] readBytes(SerializationContext ctx) {
        return this.getAndCast("byte[]", object -> object instanceof byte[], object -> (byte[])object);
    }

    @Override
    public <V> Optional<V> readOptional(SerializationContext ctx, Endec<V> endec) {
        return this.getAndCast("Optional<?>", object -> object instanceof Optional, object -> (Optional)object);
    }

    @Override
    public <E> Deserializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec) {
        return new Sequence<E>(ctx, elementEndec, this.getAndCast("List<?>", object -> object instanceof List, object -> (List)object));
    }

    @Override
    public <V> Deserializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec) {
        return new Map<V>(ctx, valueEndec, this.getAndCast("Map<String, ?>", object -> object instanceof java.util.Map, object -> (java.util.Map)object));
    }

    @Override
    public Deserializer.Struct struct() {
        return new Struct(this.getAndCast("Map<String, ?>", object -> object instanceof java.util.Map, object -> (java.util.Map)object));
    }

    @Override
    public <S> void readAny(SerializationContext ctx, Serializer<S> visitor) {
        this.visit(ctx, visitor, this.getValue());
    }

    private <S> void visit(SerializationContext ctx, Serializer<S> visitor, Object value) {
        if (value instanceof Byte) {
            Byte castedValue = (Byte)value;
            visitor.writeByte(ctx, castedValue);
        } else if (value instanceof Short) {
            Short castedValue = (Short)value;
            visitor.writeShort(ctx, castedValue);
        } else if (value instanceof Integer) {
            Integer castedValue = (Integer)value;
            visitor.writeInt(ctx, castedValue);
        } else if (value instanceof Long) {
            Long castedValue = (Long)value;
            visitor.writeLong(ctx, castedValue);
        } else if (value instanceof Float) {
            Float castedValue = (Float)value;
            visitor.writeFloat(ctx, castedValue.floatValue());
        } else if (value instanceof Double) {
            Double castedValue = (Double)value;
            visitor.writeDouble(ctx, castedValue);
        } else if (value instanceof Boolean) {
            Boolean castedValue = (Boolean)value;
            visitor.writeBoolean(ctx, castedValue);
        } else if (value instanceof String) {
            String castedValue = (String)value;
            visitor.writeString(ctx, castedValue);
        } else if (value instanceof byte[]) {
            byte[] castedValue = (byte[])value;
            visitor.writeBytes(ctx, castedValue);
        } else if (value instanceof Optional) {
            Optional castedValue = (Optional)value;
            visitor.writeOptional(ctx, Endec.of(this::visit, (ctx1, deserializer) -> null), castedValue);
        } else if (value instanceof List) {
            List list;
            List typedList = list = (List)value;
            try (Serializer.Sequence<Object> sequence = visitor.sequence(ctx, Endec.of(this::visit, (ctx1, deserializer) -> null), typedList.size());){
                typedList.forEach(sequence::element);
            }
        } else if (value instanceof java.util.Map) {
            java.util.Map map;
            java.util.Map typedMap = map = (java.util.Map)value;
            try (Serializer.Map<Object> mapDeserializer = visitor.map(ctx, Endec.of(this::visit, (ctx1, deserializer) -> null), typedMap.size());){
                typedMap.forEach(mapDeserializer::entry);
            }
        } else {
            throw new IllegalStateException("Unable to handle the following Java type: " + String.valueOf(value));
        }
    }

    private <T> T getAndCast(Class<T> clazz) {
        return (T)this.getAndCast(clazz.getSimpleName(), object -> clazz.isAssignableFrom(object.getClass()), clazz::cast);
    }

    private <T> T getAndCast(String clazzName, Predicate<Object> isCompatible, Function<Object, T> cast) {
        Object value = this.getValue();
        if (value == null) {
            throw new NullPointerException("Unable to get the value as [" + clazzName + "] since the value is currently null!");
        }
        if (!isCompatible.test(value)) {
            throw new IllegalStateException("Unable to cast the given value [" + String.valueOf(value) + "] to type of [" + clazzName + "] as such is not the compatible type!");
        }
        try {
            return cast.apply(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to cast the given java value [" + String.valueOf(value) + "] to the desired type [" + clazzName + "] as an exception has occurred: ", e);
        }
    }

    protected final class Sequence<V>
    implements Deserializer.Sequence<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final Iterator<Object> elements;
        private final int size;

        Sequence(SerializationContext ctx, Endec<V> valueEndec, List<Object> elements) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.elements = elements.iterator();
            this.size = elements.size();
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.elements.hasNext();
        }

        @Override
        public V next() {
            Object element = this.elements.next();
            return (V)JavaDeserializer.this.frame(() -> element, () -> this.valueEndec.decode(this.ctx, JavaDeserializer.this));
        }
    }

    private class Map<V>
    implements Deserializer.Map<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final Iterator<Map.Entry<String, Object>> entries;
        private final int size;

        private Map(SerializationContext ctx, Endec<V> valueEndec, java.util.Map<String, Object> entries) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.entries = entries.entrySet().iterator();
            this.size = entries.size();
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            Map.Entry<String, Object> entry = this.entries.next();
            return (Map.Entry)JavaDeserializer.this.frame(entry::getValue, () -> java.util.Map.entry((String)entry.getKey(), this.valueEndec.decode(this.ctx, JavaDeserializer.this)));
        }
    }

    private class Struct
    implements Deserializer.Struct {
        private final java.util.Map<String, Object> map;

        private Struct(java.util.Map<String, Object> map) {
            this.map = map;
        }

        @Override
        @Nullable
        public <F> F field(String name, SerializationContext ctx, Endec<F> endec, @Nullable Supplier<F> defaultValueFactory) {
            Object element = this.map.get(name);
            if (element == null) {
                if (defaultValueFactory == null) {
                    throw new IllegalStateException("Field '" + name + "' was missing from serialized data, but no default value was provided");
                }
                return defaultValueFactory.get();
            }
            return (F)JavaDeserializer.this.frame(() -> element, () -> endec.decode(ctx, JavaDeserializer.this));
        }
    }
}

