/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.edm;

import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.format.edm.EdmDeserializer;
import io.wispforest.endec.format.edm.EdmElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class LenientEdmDeserializer
extends EdmDeserializer {
    protected LenientEdmDeserializer(EdmElement<?> serialized) {
        super(serialized);
    }

    public static LenientEdmDeserializer of(EdmElement<?> serialized) {
        return new LenientEdmDeserializer(serialized);
    }

    @Override
    public byte readByte(SerializationContext ctx) {
        return ((Number)((EdmElement)this.getValue()).cast()).byteValue();
    }

    @Override
    public short readShort(SerializationContext ctx) {
        return ((Number)((EdmElement)this.getValue()).cast()).shortValue();
    }

    @Override
    public int readInt(SerializationContext ctx) {
        return ((Number)((EdmElement)this.getValue()).cast()).intValue();
    }

    @Override
    public long readLong(SerializationContext ctx) {
        return ((Number)((EdmElement)this.getValue()).cast()).longValue();
    }

    @Override
    public float readFloat(SerializationContext ctx) {
        return ((Number)((EdmElement)this.getValue()).cast()).floatValue();
    }

    @Override
    public double readDouble(SerializationContext ctx) {
        return ((Number)((EdmElement)this.getValue()).cast()).doubleValue();
    }

    @Override
    public boolean readBoolean(SerializationContext ctx) {
        Object t = ((EdmElement)this.getValue()).value();
        if (t instanceof Number) {
            Number number = (Number)t;
            return number.byteValue() == 1;
        }
        return super.readBoolean(ctx);
    }

    @Override
    public <V> Optional<V> readOptional(SerializationContext ctx, Endec<V> endec) {
        EdmElement edmElement = (EdmElement)this.getValue();
        if (edmElement == null) {
            return Optional.empty();
        }
        if (edmElement.value() instanceof Optional) {
            return super.readOptional(ctx, endec);
        }
        return Optional.of(endec.decode(ctx, this));
    }

    @Override
    public <E> Deserializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec) {
        ArrayList<EdmElement<?>> list;
        Object value = ((EdmElement)this.getValue()).value();
        if (value instanceof byte[]) {
            byte[] array = (byte[])value;
            list = new ArrayList();
            for (byte b : array) {
                list.add(EdmElement.i8(b));
            }
        } else if (value instanceof List) {
            list = (List)((EdmElement)this.getValue()).cast();
        } else {
            throw new IllegalStateException("Unable to handle the given value for sequence within LenientEdmDeserializer!");
        }
        return new EdmDeserializer.Sequence<E>(ctx, elementEndec, list);
    }
}

