/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.edm;

import io.wispforest.endec.format.edm.EdmElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EdmIo {
    public static void encode(DataOutput output, EdmElement<?> data) throws IOException {
        output.writeByte(data.type().ordinal());
        EdmIo.encodeElementData(output, data);
    }

    public static EdmElement<?> decode(DataInput input) throws IOException {
        return EdmIo.decodeElementData(input, input.readByte());
    }

    public static void encodeElementData(DataOutput output, EdmElement<?> data) throws IOException {
        switch (data.type()) {
            case I8: 
            case U8: {
                output.writeByte(((Byte)data.cast()).byteValue());
                break;
            }
            case I16: 
            case U16: {
                output.writeShort(((Short)data.cast()).shortValue());
                break;
            }
            case I32: 
            case U32: {
                output.writeInt((Integer)data.cast());
                break;
            }
            case I64: 
            case U64: {
                output.writeLong((Long)data.cast());
                break;
            }
            case F32: {
                output.writeFloat(((Float)data.cast()).floatValue());
                break;
            }
            case F64: {
                output.writeDouble((Double)data.cast());
                break;
            }
            case BOOLEAN: {
                output.writeBoolean((Boolean)data.cast());
                break;
            }
            case STRING: {
                output.writeUTF((String)data.cast());
                break;
            }
            case BYTES: {
                output.writeInt(((byte[])data.cast()).length);
                output.write((byte[])data.cast());
                break;
            }
            case OPTIONAL: {
                Optional optional = (Optional)data.cast();
                output.writeBoolean(optional.isPresent());
                if (!optional.isPresent()) break;
                EdmElement element = (EdmElement)optional.get();
                output.writeByte(element.type().ordinal());
                EdmIo.encodeElementData(output, element);
                break;
            }
            case SEQUENCE: {
                List list = (List)data.cast();
                output.writeInt(list.size());
                if (list.isEmpty()) break;
                for (EdmElement element : list) {
                    output.writeByte(element.type().ordinal());
                    EdmIo.encodeElementData(output, element);
                }
                break;
            }
            case MAP: {
                Map map = (Map)data.cast();
                output.writeInt(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    output.writeUTF((String)entry.getKey());
                    output.writeByte(((EdmElement)entry.getValue()).type().ordinal());
                    EdmIo.encodeElementData(output, (EdmElement)entry.getValue());
                }
                break;
            }
        }
    }

    private static EdmElement<?> decodeElementData(DataInput input, byte type) throws IOException {
        return switch (EdmElement.Type.values()[type]) {
            default -> throw new IncompatibleClassChangeError();
            case EdmElement.Type.I8 -> EdmElement.i8(input.readByte());
            case EdmElement.Type.U8 -> EdmElement.u8(input.readByte());
            case EdmElement.Type.I16 -> EdmElement.i16(input.readShort());
            case EdmElement.Type.U16 -> EdmElement.u16(input.readShort());
            case EdmElement.Type.I32 -> EdmElement.i32(input.readInt());
            case EdmElement.Type.U32 -> EdmElement.u32(input.readInt());
            case EdmElement.Type.I64 -> EdmElement.i64(input.readLong());
            case EdmElement.Type.U64 -> EdmElement.u64(input.readLong());
            case EdmElement.Type.F32 -> EdmElement.f32(input.readFloat());
            case EdmElement.Type.F64 -> EdmElement.f64(input.readDouble());
            case EdmElement.Type.BOOLEAN -> EdmElement.bool(input.readBoolean());
            case EdmElement.Type.STRING -> EdmElement.string(input.readUTF());
            case EdmElement.Type.BYTES -> {
                byte[] result = new byte[input.readInt()];
                input.readFully(result);
                yield EdmElement.bytes(result);
            }
            case EdmElement.Type.OPTIONAL -> {
                if (input.readByte() != 0) {
                    yield EdmElement.optional(Optional.of(EdmIo.decodeElementData(input, input.readByte())));
                }
                yield EdmElement.optional(Optional.empty());
            }
            case EdmElement.Type.SEQUENCE -> {
                int length = input.readInt();
                if (length != 0) {
                    ArrayList result = new ArrayList(length);
                    for (int i = 0; i < length; ++i) {
                        result.add(EdmIo.decodeElementData(input, input.readByte()));
                    }
                    yield EdmElement.sequence(result);
                }
                yield EdmElement.sequence(List.of());
            }
            case EdmElement.Type.MAP -> {
                int length = input.readInt();
                LinkedHashMap result = new LinkedHashMap(length);
                for (int i = 0; i < length; ++i) {
                    result.put(input.readUTF(), EdmIo.decodeElementData(input, input.readByte()));
                }
                yield EdmElement.consumeMap(result);
            }
        };
    }
}

