/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.edm;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.format.edm.EdmDeserializer;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.format.edm.EdmIo;
import io.wispforest.endec.format.edm.EdmMap;
import io.wispforest.endec.format.edm.EdmSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class EdmEndec
implements Endec<EdmElement<?>> {
    public static final EdmEndec INSTANCE = new EdmEndec();
    public static final Endec<EdmMap> MAP = INSTANCE.xmap(EdmElement::asMap, edmMap -> edmMap);

    private EdmEndec() {
    }

    @Override
    public void encode(SerializationContext ctx, Serializer<?> serializer, EdmElement<?> value) {
        if (serializer instanceof SelfDescribedSerializer) {
            new EdmDeserializer(value).readAny(ctx, serializer);
            return;
        }
        try {
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            EdmIo.encode((DataOutput)output, value);
            serializer.writeBytes(ctx, output.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to encode EDM element in EdmEndec", e);
        }
    }

    @Override
    public EdmElement<?> decode(SerializationContext ctx, Deserializer<?> deserializer) {
        if (deserializer instanceof SelfDescribedDeserializer) {
            SelfDescribedDeserializer selfDescribedDeserializer = (SelfDescribedDeserializer)deserializer;
            EdmSerializer nativeSerializer = new EdmSerializer();
            selfDescribedDeserializer.readAny(ctx, nativeSerializer);
            return (EdmElement)nativeSerializer.result();
        }
        try {
            return EdmIo.decode((DataInput)ByteStreams.newDataInput((byte[])deserializer.readBytes(ctx)));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse EDM element in EdmEndec", e);
        }
    }
}

