/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.edm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.wispforest.endec.format.edm.EdmMap;
import io.wispforest.endec.util.BlockWriter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class EdmElement<T> {
    public static final EdmElement<Optional<EdmElement<?>>> EMPTY = new EdmElement(Optional.empty(), Type.OPTIONAL);
    private final T value;
    private final Type type;

    EdmElement(T value, Type type) {
        this.value = value;
        this.type = type;
    }

    public T value() {
        return this.value;
    }

    public <V> V cast() {
        return (V)this.value;
    }

    public Type type() {
        return this.type;
    }

    public Object unwrap() {
        T t = this.value;
        if (t instanceof List) {
            List list = (List)t;
            return list.stream().map(o -> ((EdmElement)o).unwrap()).toList();
        }
        t = this.value;
        if (t instanceof Map) {
            Map map = (Map)t;
            return map.entrySet().stream().map(entry -> Map.entry(entry.getKey(), ((EdmElement)entry.getValue()).unwrap())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        t = this.value;
        if (t instanceof Optional) {
            Optional optional = (Optional)t;
            return optional.map(o -> ((EdmElement)o).unwrap());
        }
        return this.value;
    }

    public EdmMap asMap() {
        if (this.type != Type.MAP) {
            throw new IllegalStateException("Cannot cast EDM element of type " + String.valueOf((Object)this.type) + " to MAP");
        }
        return new EdmMap(new HashMap((Map)this.cast()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdmElement)) {
            return false;
        }
        EdmElement that = (EdmElement)o;
        if (!this.value.equals(that.value)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return this.format(new BlockWriter()).buildResult();
    }

    protected BlockWriter format(BlockWriter formatter) {
        return switch (this.type.ordinal()) {
            case 12 -> formatter.writeBlock("bytes(", ")", false, blockWriter -> blockWriter.write(Arrays.toString(Base64.getEncoder().encode((byte[])this.cast()))));
            case 15 -> formatter.writeBlock("map({", "})", blockWriter -> {
                Map map = (Map)this.cast();
                int idx = 0;
                for (Map.Entry entry : map.entrySet()) {
                    formatter.write("\"" + (String)entry.getKey() + "\": ");
                    ((EdmElement)entry.getValue()).format(formatter);
                    if (idx < map.size() - 1) {
                        formatter.writeln(",");
                    }
                    ++idx;
                }
            });
            case 14 -> formatter.writeBlock("sequence([", "])", blockWriter -> {
                List list = (List)this.cast();
                for (int idx = 0; idx < list.size(); ++idx) {
                    ((EdmElement)list.get(idx)).format(formatter);
                    if (idx >= list.size() - 1) continue;
                    formatter.writeln(",");
                }
            });
            case 13 -> formatter.writeBlock("optional(", ")", false, blockWriter -> {
                Optional optional = (Optional)this.cast();
                optional.ifPresentOrElse(edmElement -> edmElement.format(formatter), () -> formatter.write(""));
            });
            case 11 -> formatter.writeBlock("string(\"", "\")", false, blockWriter -> blockWriter.write(Objects.toString(this.value)));
            default -> formatter.writeBlock(this.type.formatName() + "(", ")", false, blockWriter -> blockWriter.write(Objects.toString(this.value)));
        };
    }

    public static EdmElement<Byte> i8(byte value) {
        return new EdmElement<Byte>(value, Type.I8);
    }

    public static EdmElement<Byte> u8(byte value) {
        return new EdmElement<Byte>(value, Type.U8);
    }

    public static EdmElement<Short> i16(short value) {
        return new EdmElement<Short>(value, Type.I16);
    }

    public static EdmElement<Short> u16(short value) {
        return new EdmElement<Short>(value, Type.U16);
    }

    public static EdmElement<Integer> i32(int value) {
        return new EdmElement<Integer>(value, Type.I32);
    }

    public static EdmElement<Integer> u32(int value) {
        return new EdmElement<Integer>(value, Type.U32);
    }

    public static EdmElement<Long> i64(long value) {
        return new EdmElement<Long>(value, Type.I64);
    }

    public static EdmElement<Long> u64(long value) {
        return new EdmElement<Long>(value, Type.U64);
    }

    public static EdmElement<Float> f32(float value) {
        return new EdmElement<Float>(Float.valueOf(value), Type.F32);
    }

    public static EdmElement<Double> f64(double value) {
        return new EdmElement<Double>(value, Type.F64);
    }

    public static EdmElement<Boolean> bool(boolean value) {
        return new EdmElement<Boolean>(value, Type.BOOLEAN);
    }

    public static EdmElement<String> string(String value) {
        Objects.requireNonNull(value, "EDM format does not allow for null String as a value!");
        return new EdmElement<String>(value, Type.STRING);
    }

    public static EdmElement<byte[]> bytes(byte[] value) {
        Objects.requireNonNull(value, "EDM format does not allow for null byte arrays as a value!");
        return new EdmElement<byte[]>(value, Type.BYTES);
    }

    public static EdmElement<Optional<EdmElement<?>>> optional(@Nullable EdmElement<?> value) {
        return EdmElement.optional(Optional.ofNullable(value));
    }

    public static EdmElement<Optional<EdmElement<?>>> optional(Optional<EdmElement<?>> value) {
        if (value.isEmpty()) {
            return EMPTY;
        }
        return new EdmElement(value, Type.OPTIONAL);
    }

    public static EdmElement<List<EdmElement<?>>> sequence(List<EdmElement<?>> value) {
        Objects.requireNonNull(value, "EDM format does not allow for null List as a value!");
        return new EdmElement<ImmutableList>(ImmutableList.copyOf(value), Type.SEQUENCE);
    }

    public static EdmElement<Map<String, EdmElement<?>>> map(Map<String, EdmElement<?>> value) {
        Objects.requireNonNull(value, "EDM format does not allow for null Map as a value!");
        return new EdmElement<ImmutableMap>(ImmutableMap.copyOf(value), Type.MAP);
    }

    public static EdmElement<Map<String, EdmElement<?>>> consumeMap(Map<String, EdmElement<?>> value) {
        Objects.requireNonNull(value, "EDM format does not allow for null Map as a value!");
        return new EdmElement(Collections.unmodifiableMap(value), Type.MAP);
    }

    public static enum Type {
        I8,
        U8,
        I16,
        U16,
        I32,
        U32,
        I64,
        U64,
        F32,
        F64,
        BOOLEAN,
        STRING,
        BYTES,
        OPTIONAL,
        SEQUENCE,
        MAP;


        public String formatName() {
            return this.name().toLowerCase();
        }
    }
}

