/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec.format.edm;

import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.util.RecursiveDeserializer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class EdmDeserializer
extends RecursiveDeserializer<EdmElement<?>>
implements SelfDescribedDeserializer<EdmElement<?>> {
    protected EdmDeserializer(EdmElement<?> serialized) {
        super(serialized);
    }

    public static EdmDeserializer of(EdmElement<?> serialized) {
        return new EdmDeserializer(serialized);
    }

    @Override
    public byte readByte(SerializationContext ctx) {
        return (Byte)((EdmElement)this.getValue()).cast();
    }

    @Override
    public short readShort(SerializationContext ctx) {
        return (Short)((EdmElement)this.getValue()).cast();
    }

    @Override
    public int readInt(SerializationContext ctx) {
        return (Integer)((EdmElement)this.getValue()).cast();
    }

    @Override
    public long readLong(SerializationContext ctx) {
        return (Long)((EdmElement)this.getValue()).cast();
    }

    @Override
    public float readFloat(SerializationContext ctx) {
        return ((Float)((EdmElement)this.getValue()).cast()).floatValue();
    }

    @Override
    public double readDouble(SerializationContext ctx) {
        return (Double)((EdmElement)this.getValue()).cast();
    }

    @Override
    public int readVarInt(SerializationContext ctx) {
        return this.readInt(ctx);
    }

    @Override
    public long readVarLong(SerializationContext ctx) {
        return this.readLong(ctx);
    }

    @Override
    public boolean readBoolean(SerializationContext ctx) {
        return (Boolean)((EdmElement)this.getValue()).cast();
    }

    @Override
    public String readString(SerializationContext ctx) {
        return (String)((EdmElement)this.getValue()).cast();
    }

    @Override
    public byte[] readBytes(SerializationContext ctx) {
        return (byte[])((EdmElement)this.getValue()).cast();
    }

    @Override
    public <V> Optional<V> readOptional(SerializationContext ctx, Endec<V> endec) {
        Optional optional = (Optional)((EdmElement)this.getValue()).cast();
        if (optional.isPresent()) {
            return this.frame(optional::get, () -> Optional.of(endec.decode(ctx, this)));
        }
        return Optional.empty();
    }

    @Override
    public <E> Deserializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec) {
        return new Sequence<E>(ctx, elementEndec, (List)((EdmElement)this.getValue()).cast());
    }

    @Override
    public <V> Deserializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec) {
        return new Map<V>(ctx, valueEndec, (java.util.Map)((EdmElement)this.getValue()).cast());
    }

    @Override
    public Deserializer.Struct struct() {
        return new Struct((java.util.Map)((EdmElement)this.getValue()).cast());
    }

    @Override
    public <S> void readAny(SerializationContext ctx, Serializer<S> visitor) {
        this.visit(ctx, visitor, (EdmElement)this.getValue());
    }

    private <S> void visit(SerializationContext ctx, Serializer<S> visitor, EdmElement<?> value) {
        switch (value.type()) {
            case I8: {
                visitor.writeByte(ctx, (Byte)value.cast());
                break;
            }
            case I16: {
                visitor.writeShort(ctx, (Short)value.cast());
                break;
            }
            case I32: {
                visitor.writeInt(ctx, (Integer)value.cast());
                break;
            }
            case I64: {
                visitor.writeLong(ctx, (Long)value.cast());
                break;
            }
            case F32: {
                visitor.writeFloat(ctx, ((Float)value.cast()).floatValue());
                break;
            }
            case F64: {
                visitor.writeDouble(ctx, (Double)value.cast());
                break;
            }
            case BOOLEAN: {
                visitor.writeBoolean(ctx, (Boolean)value.cast());
                break;
            }
            case STRING: {
                visitor.writeString(ctx, (String)value.cast());
                break;
            }
            case BYTES: {
                visitor.writeBytes(ctx, (byte[])value.cast());
                break;
            }
            case OPTIONAL: {
                visitor.writeOptional(ctx, Endec.of(this::visit, (ctx1, deserializer) -> null), (Optional)value.cast());
                break;
            }
            case SEQUENCE: {
                try (Serializer.Sequence<EdmElement> sequence = visitor.sequence(ctx, Endec.of(this::visit, (ctx1, deserializer) -> null), ((List)value.cast()).size());){
                    ((List)value.cast()).forEach(sequence::element);
                    break;
                }
            }
            case MAP: {
                Serializer.Map<EdmElement> map = visitor.map(ctx, Endec.of(this::visit, (ctx1, deserializer) -> null), ((java.util.Map)value.cast()).size());
                try {
                    ((java.util.Map)value.cast()).forEach(map::entry);
                    if (map == null) break;
                }
                catch (Throwable throwable) {
                    if (map != null) {
                        try {
                            map.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                map.close();
                break;
            }
        }
    }

    protected final class Sequence<V>
    implements Deserializer.Sequence<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final Iterator<EdmElement<?>> elements;
        private final int size;

        Sequence(SerializationContext ctx, Endec<V> valueEndec, List<EdmElement<?>> elements) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.elements = elements.iterator();
            this.size = elements.size();
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.elements.hasNext();
        }

        @Override
        public V next() {
            EdmElement<?> element = this.elements.next();
            return (V)EdmDeserializer.this.frame(() -> element, () -> this.valueEndec.decode(this.ctx, EdmDeserializer.this));
        }
    }

    private class Map<V>
    implements Deserializer.Map<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final Iterator<Map.Entry<String, EdmElement<?>>> entries;
        private final int size;

        private Map(SerializationContext ctx, Endec<V> valueEndec, java.util.Map<String, EdmElement<?>> entries) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.entries = entries.entrySet().iterator();
            this.size = entries.size();
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            Map.Entry<String, EdmElement<?>> entry = this.entries.next();
            return (Map.Entry)EdmDeserializer.this.frame(entry::getValue, () -> java.util.Map.entry((String)entry.getKey(), this.valueEndec.decode(this.ctx, EdmDeserializer.this)));
        }
    }

    private class Struct
    implements Deserializer.Struct {
        private final java.util.Map<String, EdmElement<?>> map;

        private Struct(java.util.Map<String, EdmElement<?>> map) {
            this.map = map;
        }

        @Override
        @Nullable
        public <F> F field(String name, SerializationContext ctx, Endec<F> endec, @Nullable Supplier<F> defaultValueFactory) {
            EdmElement<?> element = this.map.get(name);
            if (element == null) {
                if (defaultValueFactory == null) {
                    throw new IllegalStateException("Field '" + name + "' was missing from serialized data, but no default value was provided");
                }
                return defaultValueFactory.get();
            }
            return (F)EdmDeserializer.this.frame(() -> element, () -> endec.decode(ctx, EdmDeserializer.this));
        }
    }
}

