/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec;

import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.impl.AttributeStructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface StructEndec<T>
extends Endec<T> {
    public void encodeStruct(SerializationContext var1, Serializer<?> var2, Serializer.Struct var3, T var4);

    public T decodeStruct(SerializationContext var1, Deserializer<?> var2, Deserializer.Struct var3);

    public static <T> StructEndec<T> of(final StructuredEncoder<T> encoder, final StructuredDecoder<T> decoder) {
        return new StructEndec<T>(){

            @Override
            public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) {
                encoder.encodeStruct(ctx, serializer, struct, value);
            }

            @Override
            public T decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
                return decoder.decodeStruct(ctx, deserializer, struct);
            }
        };
    }

    @Override
    default public void encode(SerializationContext ctx, Serializer<?> serializer, T value) {
        try (Serializer.Struct struct = serializer.struct();){
            this.encodeStruct(ctx, serializer, struct, value);
        }
    }

    @Override
    default public T decode(SerializationContext ctx, Deserializer<?> deserializer) {
        return this.decodeStruct(ctx, deserializer, deserializer.struct());
    }

    @Deprecated(forRemoval=true)
    public static <T> StructEndec<T> unit(T instance) {
        return Endec.unit(instance);
    }

    @Deprecated(forRemoval=true)
    public static <T> StructEndec<T> unit(Supplier<T> instance) {
        return Endec.unit(instance);
    }

    public static <T> AttributeStructEndecBuilder<T> ifAttr(SerializationAttribute attribute, StructEndec<T> endec) {
        return new AttributeStructEndecBuilder<T>(endec, attribute);
    }

    default public <S> StructField<S, T> flatFieldOf(Function<S, T> getter) {
        return new StructField.Flat<S, T>(this, getter);
    }

    default public <M extends T> StructField<M, T> flatInheritedFieldOf() {
        return new StructField.Flat<Object, Object>(this, m -> m);
    }

    @Override
    default public <R> StructEndec<R> xmap(Function<T, R> to, Function<R, T> from) {
        return StructEndec.of((SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) -> this.encodeStruct(ctx, serializer, struct, from.apply(value)), (SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) -> to.apply(this.decodeStruct(ctx, deserializer, struct)));
    }

    @Override
    default public <R> StructEndec<R> xmapWithContext(BiFunction<SerializationContext, T, R> to, BiFunction<SerializationContext, R, T> from) {
        return StructEndec.of((SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) -> this.encodeStruct(ctx, serializer, struct, from.apply(ctx, value)), (SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) -> to.apply(ctx, this.decodeStruct(ctx, deserializer, struct)));
    }

    default public StructEndec<T> structuredCatchErrors(StructuredDecoderWithError<T> decodeOnError) {
        return StructEndec.of(this::encodeStruct, (SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) -> {
            try {
                return deserializer.tryRead(deserializer1 -> this.decodeStruct(ctx, (Deserializer<?>)deserializer1, struct));
            }
            catch (Exception e) {
                return decodeOnError.decodeStruct(ctx, deserializer, struct, e);
            }
        });
    }

    @Override
    default public StructEndec<T> validate(Consumer<T> validator) {
        return this.xmap(t -> {
            validator.accept(t);
            return t;
        }, (T t) -> {
            validator.accept(t);
            return t;
        });
    }

    @FunctionalInterface
    public static interface StructuredEncoder<T> {
        public void encodeStruct(SerializationContext var1, Serializer<?> var2, Serializer.Struct var3, T var4);
    }

    @FunctionalInterface
    public static interface StructuredDecoder<T> {
        public T decodeStruct(SerializationContext var1, Deserializer<?> var2, Deserializer.Struct var3);
    }

    @FunctionalInterface
    public static interface StructuredDecoderWithError<T> {
        public T decodeStruct(SerializationContext var1, Deserializer<?> var2, Deserializer.Struct var3, Exception var4);
    }
}

