/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec;

import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.impl.MissingAttributeValueException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SerializationContext {
    private static final SerializationContext EMPTY = new SerializationContext(Map.of(), Set.of());
    private final Map<SerializationAttribute, Object> attributeValues;
    private final Set<SerializationAttribute> suppressedAttributes;

    private SerializationContext(Map<SerializationAttribute, Object> attributeValues, Set<SerializationAttribute> suppressedAttributes) {
        this.attributeValues = Collections.unmodifiableMap(attributeValues);
        this.suppressedAttributes = Collections.unmodifiableSet(suppressedAttributes);
    }

    public static SerializationContext empty() {
        return EMPTY;
    }

    public static SerializationContext attributes(SerializationAttribute.Instance ... attributes) {
        if (attributes.length == 0) {
            return EMPTY;
        }
        return new SerializationContext(SerializationContext.unpackAttributes(attributes), Set.of());
    }

    public static SerializationContext suppressed(SerializationAttribute ... attributes) {
        if (attributes.length == 0) {
            return EMPTY;
        }
        return new SerializationContext(Map.of(), Set.of(attributes));
    }

    public SerializationContext withAttributes(SerializationAttribute.Instance ... attributes) {
        Map<SerializationAttribute, Object> newAttributes = SerializationContext.unpackAttributes(attributes);
        this.attributeValues.forEach((attribute, value) -> {
            if (!newAttributes.containsKey(attribute)) {
                newAttributes.put((SerializationAttribute)attribute, value);
            }
        });
        return new SerializationContext(newAttributes, this.suppressedAttributes);
    }

    public SerializationContext withoutAttributes(SerializationAttribute ... attributes) {
        HashMap<SerializationAttribute, Object> newAttributes = new HashMap<SerializationAttribute, Object>(this.attributeValues);
        for (SerializationAttribute attribute : attributes) {
            newAttributes.remove(attribute);
        }
        return new SerializationContext(newAttributes, this.suppressedAttributes);
    }

    public SerializationContext withSuppressed(SerializationAttribute ... attributes) {
        HashSet<SerializationAttribute> newSuppressed = new HashSet<SerializationAttribute>(this.suppressedAttributes);
        newSuppressed.addAll(Arrays.asList(attributes));
        return new SerializationContext(this.attributeValues, newSuppressed);
    }

    public SerializationContext withoutSuppressed(SerializationAttribute ... attributes) {
        HashSet<SerializationAttribute> newSuppressed = new HashSet<SerializationAttribute>(this.suppressedAttributes);
        for (SerializationAttribute attribute : attributes) {
            newSuppressed.remove(attribute);
        }
        return new SerializationContext(this.attributeValues, newSuppressed);
    }

    public SerializationContext and(SerializationContext other) {
        if (this.isEmpty()) {
            return other.isEmpty() ? EMPTY : other;
        }
        if (other.isEmpty()) {
            return this;
        }
        HashMap<SerializationAttribute, Object> newAttributeValues = new HashMap<SerializationAttribute, Object>(this.attributeValues);
        newAttributeValues.putAll(other.attributeValues);
        HashSet<SerializationAttribute> newSuppressed = new HashSet<SerializationAttribute>(this.suppressedAttributes);
        newSuppressed.addAll(other.suppressedAttributes);
        return new SerializationContext(newAttributeValues, newSuppressed);
    }

    public boolean hasAttribute(SerializationAttribute attribute) {
        return this.attributeValues.containsKey(attribute) && !this.suppressedAttributes.contains(attribute);
    }

    public <A> A getAttributeValue(SerializationAttribute.WithValue<A> attribute) {
        return (A)this.attributeValues.get(attribute);
    }

    public <A> A requireAttributeValue(SerializationAttribute.WithValue<A> attribute) {
        if (!this.hasAttribute(attribute)) {
            throw new MissingAttributeValueException("Context did not provide a value for attribute '" + attribute.name + "'");
        }
        return this.getAttributeValue(attribute);
    }

    public boolean isEmpty() {
        return this.attributeValues.isEmpty() && this.suppressedAttributes.isEmpty();
    }

    private static Map<SerializationAttribute, Object> unpackAttributes(SerializationAttribute.Instance[] attributes) {
        HashMap<SerializationAttribute, Object> attributeValues = new HashMap<SerializationAttribute, Object>();
        for (SerializationAttribute.Instance instance : attributes) {
            attributeValues.put(instance.attribute(), instance.value());
        }
        return attributeValues;
    }
}

