/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.endec;

import io.wispforest.endec.Deserializer;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationAttributes;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.AttributeEndecBuilder;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.impl.OptionalEndec;
import io.wispforest.endec.impl.RecursiveEndec;
import io.wispforest.endec.impl.RecursiveStructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.endec.util.RangeNumberException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;

public interface Endec<T> {
    public static final Endec<Void> VOID = Endec.of((ctx, serializer, unused) -> {}, (ctx, deserializer) -> null);
    public static final Endec<Boolean> BOOLEAN = Endec.of((ctx, serializer, value) -> serializer.writeBoolean(ctx, (boolean)value), (ctx, deserializer) -> deserializer.readBoolean(ctx));
    public static final Endec<Byte> BYTE = Endec.of((ctx, serializer, value) -> serializer.writeByte(ctx, (byte)value), (ctx, deserializer) -> deserializer.readByte(ctx));
    public static final Endec<Short> SHORT = Endec.of((ctx, serializer, value) -> serializer.writeShort(ctx, (short)value), (ctx, deserializer) -> deserializer.readShort(ctx));
    public static final Endec<Integer> INT = Endec.of((ctx, serializer, value) -> serializer.writeInt(ctx, (int)value), (ctx, deserializer) -> deserializer.readInt(ctx));
    public static final Endec<Integer> VAR_INT = Endec.of((ctx, serializer, value) -> serializer.writeVarInt(ctx, (int)value), (ctx, deserializer) -> deserializer.readVarInt(ctx));
    public static final Endec<Long> LONG = Endec.of((ctx, serializer, value) -> serializer.writeLong(ctx, (long)value), (ctx, deserializer) -> deserializer.readLong(ctx));
    public static final Endec<Long> VAR_LONG = Endec.of((ctx, serializer, value) -> serializer.writeVarLong(ctx, (long)value), (ctx, deserializer) -> deserializer.readVarLong(ctx));
    public static final Endec<Float> FLOAT = Endec.of((ctx, serializer, value) -> serializer.writeFloat(ctx, value.floatValue()), (ctx, deserializer) -> Float.valueOf(deserializer.readFloat(ctx)));
    public static final Endec<Double> DOUBLE = Endec.of((ctx, serializer, value) -> serializer.writeDouble(ctx, (double)value), (ctx, deserializer) -> deserializer.readDouble(ctx));
    public static final Endec<String> STRING = Endec.of((ctx, serializer, value) -> serializer.writeString(ctx, (String)value), (ctx, deserializer) -> deserializer.readString(ctx));
    public static final Endec<byte[]> BYTES = Endec.of((ctx, serializer, value) -> serializer.writeBytes(ctx, (byte[])value), (ctx, deserializer) -> deserializer.readBytes(ctx));

    public void encode(SerializationContext var1, Serializer<?> var2, T var3);

    public T decode(SerializationContext var1, Deserializer<?> var2);

    default public <E> E encodeFully(SerializationContext ctx, Supplier<Serializer<E>> serializerConstructor, T value) {
        Serializer<E> serializer = serializerConstructor.get();
        this.encode(serializer.setupContext(ctx), serializer, value);
        return serializer.result();
    }

    default public <E> E encodeFully(Supplier<Serializer<E>> serializerConstructor, T value) {
        return this.encodeFully(SerializationContext.empty(), serializerConstructor, value);
    }

    default public <E> T decodeFully(SerializationContext ctx, Function<E, Deserializer<E>> deserializerConstructor, E value) {
        Deserializer<E> deserializer = deserializerConstructor.apply(value);
        return this.decode(deserializer.setupContext(ctx), deserializer);
    }

    default public <E> T decodeFully(Function<E, Deserializer<E>> deserializerConstructor, E value) {
        return this.decodeFully(SerializationContext.empty(), deserializerConstructor, value);
    }

    default public Endec<List<T>> listOf() {
        return Endec.of((ctx, serializer, list) -> {
            try (Serializer.Sequence sequence = serializer.sequence(ctx, this, list.size());){
                list.forEach(sequence::element);
            }
        }, (ctx, deserializer) -> {
            Deserializer.Sequence<Object> sequenceState = deserializer.sequence(ctx, this);
            ArrayList list = new ArrayList(sequenceState.estimatedSize());
            sequenceState.forEachRemaining(list::add);
            return list;
        });
    }

    default public Endec<Map<String, T>> mapOf() {
        return this.mapOf(HashMap::new);
    }

    default public <M extends Map<String, T>> Endec<M> mapOf(IntFunction<M> mapConstructor) {
        return Endec.of((ctx, serializer, map) -> {
            try (Serializer.Map mapState = serializer.map(ctx, this, map.size());){
                map.forEach(mapState::entry);
            }
        }, (ctx, deserializer) -> {
            Deserializer.Map mapState = deserializer.map(ctx, this);
            Map map = (Map)mapConstructor.apply(mapState.estimatedSize());
            mapState.forEachRemaining(entry -> map.put((String)entry.getKey(), entry.getValue()));
            return map;
        });
    }

    default public <K> Endec<Map<K, T>> mapOf(Function<K, String> keyToString, Function<String, K> stringToKey) {
        return this.mapOf(HashMap::new, keyToString, stringToKey);
    }

    default public <K, M extends Map<K, T>> Endec<M> mapOf(IntFunction<M> mapConstructor, Function<K, String> keyToString, Function<String, K> stringToKey) {
        return Endec.map(mapConstructor, keyToString, stringToKey, this);
    }

    default public Endec<Optional<T>> optionalOf() {
        return Endec.of((ctx, serializer, value) -> serializer.writeOptional(ctx, this, value), (ctx, deserializer) -> deserializer.readOptional(ctx, this));
    }

    public static <T> Endec<T> of(final Encoder<T> encoder, final Decoder<T> decoder) {
        return new Endec<T>(){

            @Override
            public void encode(SerializationContext ctx, Serializer<?> serializer, T value) {
                encoder.encode(ctx, serializer, value);
            }

            @Override
            public T decode(SerializationContext ctx, Deserializer<?> deserializer) {
                return decoder.decode(ctx, deserializer);
            }
        };
    }

    public static <T> Endec<T> recursive(UnaryOperator<Endec<T>> builderFunc) {
        return new RecursiveEndec<T>(builderFunc);
    }

    public static <T> StructEndec<T> unit(T instance) {
        return Endec.unit(() -> instance);
    }

    public static <T> StructEndec<T> unit(Supplier<T> instance) {
        return StructEndec.of((SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) -> {}, (SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) -> instance.get());
    }

    default public StructEndec<T> structOf(String name) {
        return StructEndec.of((SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) -> struct.field(name, ctx, this, value), (SerializationContext ctx, Deserializer<?> serializer, Deserializer.Struct struct) -> struct.field(name, ctx, this));
    }

    public static <T> StructEndec<T> recursiveStruct(UnaryOperator<StructEndec<T>> builderFunc) {
        return new RecursiveStructEndec<T>(builderFunc);
    }

    public static <K, V> Endec<Map<K, V>> map(Endec<K> keyEndec, Endec<V> valueEndec) {
        return StructEndecBuilder.of(keyEndec.fieldOf("k", Map.Entry::getKey), valueEndec.fieldOf("v", Map.Entry::getValue), Map::entry).listOf().xmap(entries -> Map.ofEntries((Map.Entry[])entries.toArray(Map.Entry[]::new)), kvMap -> List.copyOf(kvMap.entrySet()));
    }

    public static <K, V> Endec<Map<K, V>> map(Function<K, String> keyToString, Function<String, K> stringToKey, Endec<V> valueEndec) {
        return Endec.map(HashMap::new, keyToString, stringToKey, valueEndec);
    }

    public static <K, V, M extends Map<K, V>> Endec<M> map(IntFunction<M> mapConstructor, Function<K, String> keyToString, Function<String, K> stringToKey, Endec<V> valueEndec) {
        return Endec.of((ctx, serializer, map) -> {
            try (Serializer.Map mapState = serializer.map(ctx, valueEndec, map.size());){
                map.forEach((k, v) -> mapState.entry((String)keyToString.apply(k), v));
            }
        }, (ctx, deserializer) -> {
            Deserializer.Map mapState = deserializer.map(ctx, valueEndec);
            Map map = (Map)mapConstructor.apply(mapState.estimatedSize());
            mapState.forEachRemaining(entry -> map.put(stringToKey.apply((String)entry.getKey()), entry.getValue()));
            return map;
        });
    }

    public static <E extends Enum<E>> Endec<E> forEnum(Class<E> enumClass) {
        return Endec.forEnum(enumClass, true);
    }

    public static <E extends Enum<E>> Endec<E> forEnum(Class<E> enumClass, boolean caseSensitive) {
        return Endec.forEnum(enumClass, Enum::name, caseSensitive);
    }

    public static <E extends Enum<E>> Endec<E> forEnum(Class<E> enumClass, Function<E, String> nameLookup, boolean caseSensitive) {
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        HashMap<String, Enum> serializedNames = new HashMap<String, Enum>();
        for (Enum enumValue : enumValues) {
            String valueName = nameLookup.apply(enumValue);
            if (!caseSensitive && serializedNames.containsKey(valueName = valueName.toLowerCase(Locale.ROOT))) {
                throw new IllegalStateException("Unable to add Enum entry [" + valueName + "] as with caseInsensitive mode leads to duplicate named values!");
            }
            serializedNames.put(valueName, enumValue);
        }
        return Endec.ifAttr(SerializationAttributes.HUMAN_READABLE, STRING.xmap(name -> {
            Enum entry = (Enum)serializedNames.get(caseSensitive ? name : name.toLowerCase(Locale.ROOT));
            if (entry == null) {
                throw new IllegalStateException(enumClass.getCanonicalName() + " constant with the name of [" + name + "] could not be located!");
            }
            return entry;
        }, nameLookup)).orElse(VAR_INT.xmap(ordinal -> enumValues[ordinal], Enum::ordinal));
    }

    public static <T, K> StructEndec<T> dispatchedStruct(Function<K, StructEndec<? extends T>> variantToEndec, Function<T, K> instanceToVariant, Endec<K> variantEndec) {
        return Endec.dispatchedStruct(variantToEndec, instanceToVariant, variantEndec, "type");
    }

    public static <T, K> StructEndec<T> dispatchedStruct(final Function<K, StructEndec<? extends T>> variantToEndec, final Function<T, K> instanceToVariant, final Endec<K> variantEndec, final String variantKey) {
        return new StructEndec<T>(){

            @Override
            public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) {
                Object variant = instanceToVariant.apply(value);
                struct.field(variantKey, ctx, variantEndec, variant);
                ((StructEndec)variantToEndec.apply(variant)).encodeStruct(ctx, serializer, struct, value);
            }

            @Override
            public T decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
                Object variant = struct.field(variantKey, ctx, variantEndec);
                return ((StructEndec)variantToEndec.apply(variant)).decodeStruct(ctx, deserializer, struct);
            }
        };
    }

    public static <T, K> StructEndec<T> dispatched(final Function<K, Endec<? extends T>> variantToEndec, final Function<T, K> instanceToVariant, final Endec<K> variantEndec) {
        return new StructEndec<T>(){

            @Override
            public void encodeStruct(SerializationContext ctx, Serializer<?> serializer, Serializer.Struct struct, T value) {
                Object variant = instanceToVariant.apply(value);
                struct.field("variant", ctx, variantEndec, variant);
                struct.field("instance", ctx, (Endec)variantToEndec.apply(variant), value);
            }

            @Override
            public T decodeStruct(SerializationContext ctx, Deserializer<?> deserializer, Deserializer.Struct struct) {
                Object variant = struct.field("variant", ctx, variantEndec);
                return struct.field("instance", ctx, (Endec)variantToEndec.apply(variant));
            }
        };
    }

    public static <T> AttributeEndecBuilder<T> ifAttr(SerializationAttribute attribute, Endec<T> endec) {
        return new AttributeEndecBuilder<T>(endec, attribute);
    }

    default public <R> Endec<R> xmap(Function<T, R> to, Function<R, T> from) {
        return Endec.of((ctx, serializer, value) -> this.encode(ctx, serializer, from.apply(value)), (ctx, deserializer) -> to.apply(this.decode(ctx, deserializer)));
    }

    default public <R> Endec<R> xmapWithContext(BiFunction<SerializationContext, T, R> to, BiFunction<SerializationContext, R, T> from) {
        return Endec.of((ctx, serializer, value) -> this.encode(ctx, serializer, from.apply(ctx, value)), (ctx, deserializer) -> to.apply(ctx, this.decode(ctx, deserializer)));
    }

    default public Endec<T> validate(Consumer<T> validator) {
        return this.xmap(t -> {
            validator.accept(t);
            return t;
        }, t -> {
            validator.accept(t);
            return t;
        });
    }

    public static <N extends Number> Endec<N> clampedMax(Endec<N> endec, N max) {
        return Endec.clamped(endec, null, max);
    }

    public static <N extends Number> Endec<N> rangedMax(Endec<N> endec, N max, boolean throwError) {
        return Endec.ranged(endec, null, max, throwError);
    }

    public static <N extends Number> Endec<N> clampedMin(Endec<N> endec, N min) {
        return Endec.clamped(endec, min, null);
    }

    public static <N extends Number> Endec<N> rangedMin(Endec<N> endec, N min, boolean throwError) {
        return Endec.ranged(endec, min, null, throwError);
    }

    public static <N extends Number> Endec<N> clamped(Endec<N> endec, @Nullable N min, @Nullable N max) {
        return Endec.ranged(endec, min, max, false);
    }

    public static <N extends Number> Endec<N> ranged(Endec<N> endec, @Nullable N min, @Nullable N max, boolean throwError) {
        Function<Number, Number> errorChecker = n -> {
            if (min != null && ((Comparable)((Object)n)).compareTo(min) < 0) {
                if (throwError) {
                    throw new RangeNumberException((Number)n, min, max);
                }
                return min;
            }
            if (max != null && ((Comparable)((Object)n)).compareTo(max) > 0) {
                if (throwError) {
                    throw new RangeNumberException((Number)n, min, max);
                }
                return max;
            }
            return n;
        };
        return endec.xmap(x$0 -> (Number)errorChecker.apply((Number)x$0), x$0 -> (Number)errorChecker.apply((Number)x$0));
    }

    default public Endec<T> catchErrors(DecoderWithError<T> decodeOnError) {
        return Endec.of(this::encode, (ctx, deserializer) -> {
            try {
                return deserializer.tryRead(deserializer1 -> this.decode(ctx, (Deserializer<?>)deserializer1));
            }
            catch (Exception e) {
                return decodeOnError.decode(ctx, deserializer, e);
            }
        });
    }

    default public Endec<Set<T>> setOf() {
        return this.listOf().xmap(HashSet::new, ArrayList::new);
    }

    default public <C extends Collection<T>> Endec<C> collectionOf(Supplier<C> supplier) {
        return this.listOf().xmap(ts -> {
            Collection collection = (Collection)supplier.get();
            collection.addAll(ts);
            return collection;
        }, ArrayList::new);
    }

    default public Endec<@Nullable T> nullableOf() {
        return this.optionalOf((T)null);
    }

    default public Endec<T> optionalOf(T defaultValue) {
        return this.optionalOf(() -> defaultValue);
    }

    default public Endec<T> optionalOf(Supplier<T> defaultValue) {
        return new OptionalEndec<T>(this.optionalOf(), defaultValue);
    }

    default public KeyedEndec<T> keyed(String key, T defaultValue) {
        return new KeyedEndec<T>(key, this, defaultValue);
    }

    default public KeyedEndec<T> keyed(String key, Supplier<T> defaultValueFactory) {
        return new KeyedEndec<Supplier<T>>(key, this, defaultValueFactory);
    }

    default public <S> StructField<S, T> fieldOf(String name, Function<S, T> getter) {
        return new StructField<S, T>(name, this, getter);
    }

    @Deprecated
    default public <S> StructField<S, @Nullable T> optionalFieldOf(String name, Function<S, @Nullable T> getter) {
        return this.nullableFieldOf(name, getter);
    }

    default public <S> StructField<S, @Nullable T> nullableFieldOf(String name, Function<S, @Nullable T> getter) {
        return this.optionalFieldOf(name, getter, (T)null);
    }

    default public <S> StructField<S, T> optionalFieldOf(String name, Function<S, T> getter, @Nullable T defaultValue) {
        return new StructField<S, T>(name, this.optionalOf(defaultValue), getter, defaultValue);
    }

    default public <S> StructField<S, T> optionalFieldOf(String name, Function<S, T> getter, Supplier<@Nullable T> defaultValue) {
        Objects.requireNonNull(defaultValue, "Supplier was found to be null which is not permitted for optionalFieldOf");
        return new StructField<S, Supplier<T>>(name, this.optionalOf(defaultValue), getter, defaultValue);
    }

    @FunctionalInterface
    public static interface Encoder<T> {
        public void encode(SerializationContext var1, Serializer<?> var2, T var3);
    }

    @FunctionalInterface
    public static interface Decoder<T> {
        public T decode(SerializationContext var1, Deserializer<?> var2);
    }

    @FunctionalInterface
    public static interface DecoderWithError<T> {
        public T decode(SerializationContext var1, Deserializer<?> var2, Exception var3);
    }
}

