/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.addon.access.EntityVariantHelper;
import snownee.jade.api.Accessor;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EmptyAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.JadeIds;
import snownee.jade.api.callback.JadeAfterRenderCallback;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeBeforeTooltipCollectCallback;
import snownee.jade.api.callback.JadeItemModNameCallback;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.platform.CustomEnchantPower;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ProgressView;
import snownee.jade.gui.PluginsConfigScreen;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.impl.BlockAccessorImpl;
import snownee.jade.impl.CallbackContainer;
import snownee.jade.impl.EmptyAccessorImpl;
import snownee.jade.impl.EntityAccessorImpl;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.entry.BooleanConfigEntry;
import snownee.jade.impl.config.entry.ConfigEntry;
import snownee.jade.impl.config.entry.EnumConfigEntry;
import snownee.jade.impl.config.entry.FloatConfigEntry;
import snownee.jade.impl.config.entry.IntConfigEntry;
import snownee.jade.impl.config.entry.StringConfigEntry;
import snownee.jade.impl.lookup.HierarchyLookup;
import snownee.jade.overlay.DatapackBlockManager;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.ModIdentification;

public class WailaClientRegistration
implements IWailaClientRegistration {
    private static volatile WailaClientRegistration INSTANCE;
    public final HierarchyLookup<IComponentProvider<BlockAccessor>> blockIconProviders;
    public final HierarchyLookup<IComponentProvider<BlockAccessor>> blockComponentProviders;
    public final HierarchyLookup<IComponentProvider<EntityAccessor>> entityIconProviders;
    public final HierarchyLookup<IComponentProvider<EntityAccessor>> entityComponentProviders;
    public final CallbackContainer<JadeAfterRenderCallback> afterRenderCallback = new CallbackContainer();
    public final CallbackContainer<JadeBeforeRenderCallback> beforeRenderCallback = new CallbackContainer();
    public final CallbackContainer<JadeRayTraceCallback> rayTraceCallback = new CallbackContainer();
    public final CallbackContainer<JadeTooltipCollectedCallback> tooltipCollectedCallback = new CallbackContainer();
    public final CallbackContainer<JadeItemModNameCallback> itemModNameCallback = new CallbackContainer();
    public final CallbackContainer<JadeBeforeTooltipCollectCallback> beforeTooltipCollectCallback = new CallbackContainer();
    public final Map<class_2960, ConfigEntry<?>> configEntries = Maps.newHashMap();
    public final Multimap<class_2960, class_2561> configCategoryOverrides = ArrayListMultimap.create();
    public final Map<class_2248, CustomEnchantPower> customEnchantPowers = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_1799, ItemView>> itemStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<FluidView.Data, FluidView>> fluidStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<EnergyView.Data, EnergyView>> energyStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<ProgressView.Data, ProgressView>> progressProviders = Maps.newHashMap();
    public final Set<class_2960> clientFeatures = Sets.newHashSet();
    public final Map<Class<Accessor<?>>, AccessorClientHandler<Accessor<?>>> accessorHandlers = Maps.newIdentityHashMap();

    WailaClientRegistration() {
        this.blockIconProviders = new HierarchyLookup(class_2248.class);
        this.blockComponentProviders = new HierarchyLookup(class_2248.class);
        this.entityIconProviders = new HierarchyLookup(class_1297.class);
        this.entityComponentProviders = new HierarchyLookup(class_1297.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WailaClientRegistration instance() {
        if (INSTANCE != null) return INSTANCE;
        Jade.LOGGER.error("WailaClientRegistration is not initialized yet.");
        Class<WailaClientRegistration> clazz = WailaClientRegistration.class;
        synchronized (WailaClientRegistration.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new WailaClientRegistration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<WailaClientRegistration> clazz = WailaClientRegistration.class;
        synchronized (WailaClientRegistration.class) {
            INSTANCE = new WailaClientRegistration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void registerBlockIcon(IComponentProvider<BlockAccessor> provider, Class<? extends class_2248> blockClass) {
        this.blockIconProviders.register(blockClass, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerBlockComponent(IComponentProvider<BlockAccessor> provider, Class<? extends class_2248> blockClass) {
        this.blockComponentProviders.register(blockClass, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerEntityIcon(IComponentProvider<EntityAccessor> provider, Class<? extends class_1297> entityClass) {
        this.entityIconProviders.register(entityClass, provider);
        this.tryAddConfig(provider);
    }

    @Override
    public void registerEntityComponent(IComponentProvider<EntityAccessor> provider, Class<? extends class_1297> entityClass) {
        this.entityComponentProviders.register(entityClass, provider);
        this.tryAddConfig(provider);
    }

    public List<IComponentProvider<BlockAccessor>> getBlockProviders(class_2248 block, Predicate<IComponentProvider<? extends Accessor<?>>> filter) {
        return this.blockComponentProviders.get(block).stream().filter(filter).toList();
    }

    public List<IComponentProvider<BlockAccessor>> getBlockIconProviders(class_2248 block, Predicate<IComponentProvider<? extends Accessor<?>>> filter) {
        return this.blockIconProviders.get(block).stream().filter(filter).toList();
    }

    public List<IComponentProvider<EntityAccessor>> getEntityProviders(class_1297 entity, Predicate<IComponentProvider<? extends Accessor<?>>> filter) {
        return this.entityComponentProviders.get(entity).stream().filter(filter).toList();
    }

    public List<IComponentProvider<EntityAccessor>> getEntityIconProviders(class_1297 entity, Predicate<IComponentProvider<? extends Accessor<?>>> filter) {
        return this.entityIconProviders.get(entity).stream().filter(filter).toList();
    }

    public void addConfig(ConfigEntry<?> entry) {
        Objects.requireNonNull(entry);
        Preconditions.checkArgument((StringUtils.countMatches((CharSequence)entry.id().method_12832(), (char)'.') <= 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.hasConfig(entry.id()) ? 1 : 0) != 0, (String)"Duplicate config key: %s", (Object)entry.id());
        Preconditions.checkArgument((boolean)entry.isValidValue(entry.defaultValue()), (String)"Default value of config %s does not pass value check", (Object)entry.id());
        this.configEntries.put(entry.id(), entry);
    }

    @Override
    public void addConfig(class_2960 key, boolean defaultValue) {
        this.addConfig(new BooleanConfigEntry(key, defaultValue));
    }

    @Override
    public <T extends Enum<T>> void addConfig(class_2960 key, T defaultValue) {
        Objects.requireNonNull(defaultValue);
        this.addConfig(new EnumConfigEntry<T>(key, defaultValue));
    }

    @Override
    public void addConfig(class_2960 key, String defaultValue, Predicate<String> validator) {
        Objects.requireNonNull(defaultValue);
        Objects.requireNonNull(validator);
        this.addConfig(new StringConfigEntry(key, defaultValue, validator));
    }

    @Override
    public void addConfig(class_2960 key, int defaultValue, int min, int max, boolean slider) {
        this.addConfig(new IntConfigEntry(key, defaultValue, min, max, slider));
    }

    @Override
    public void addConfig(class_2960 key, float defaultValue, float min, float max, boolean slider) {
        this.addConfig(new FloatConfigEntry(key, defaultValue, min, max, slider));
    }

    @Override
    public void addConfigListener(class_2960 key, Consumer<class_2960> listener) {
        Objects.requireNonNull(listener);
        Preconditions.checkArgument((boolean)this.hasConfig(key), (String)"Unknown config key: %s", (Object)key);
        Objects.requireNonNull(this.getConfigEntry(key)).addListener(listener);
    }

    @Override
    public void setConfigCategoryOverride(class_2960 key, class_2561 override) {
        Preconditions.checkArgument((!JadeIds.isAccess(key) ? 1 : 0) != 0, (Object)"Cannot override option from access category");
        Preconditions.checkArgument((boolean)IPluginConfig.isPrimaryKey(key), (Object)"Only primary config key can be overridden");
        Preconditions.checkArgument((boolean)this.hasConfig(key), (String)"Unknown config key: %s", (Object)key);
        this.configCategoryOverrides.put((Object)key, (Object)override);
    }

    @Override
    public void setConfigCategoryOverride(class_2960 key, List<class_2561> overrides) {
        for (class_2561 override : overrides) {
            this.setConfigCategoryOverride(key, override);
        }
    }

    private void tryAddConfig(IToggleableProvider provider) {
        if (!provider.isRequired() && !this.hasConfig(provider.getUid())) {
            this.addConfig(provider.getUid(), provider.enabledByDefault());
        }
    }

    @Override
    public Set<class_2960> getConfigKeys(String namespace) {
        return this.getConfigKeys().stream().filter(id -> id.method_12836().equals(namespace)).collect(Collectors.toSet());
    }

    @Override
    public Set<class_2960> getConfigKeys() {
        return this.configEntries.keySet();
    }

    @Override
    public boolean hasConfig(class_2960 key) {
        return this.getConfigKeys().contains(key);
    }

    @Nullable
    public ConfigEntry<?> getConfigEntry(class_2960 key) {
        return this.configEntries.get(key);
    }

    public List<Category> getConfigListView(boolean enableAccessibilityPlugins) {
        ArrayListMultimap categoryMap = ArrayListMultimap.create();
        this.configCategoryOverrides.forEach((arg_0, arg_1) -> this.lambda$getConfigListView$1((Multimap)categoryMap, arg_0, arg_1));
        this.configEntries.forEach((arg_0, arg_1) -> this.lambda$getConfigListView$2(enableAccessibilityPlugins, (Multimap)categoryMap, arg_0, arg_1));
        return categoryMap.asMap().entrySet().stream().map(e -> new Category(class_2561.method_43470((String)((String)e.getKey())), ((Collection)e.getValue()).stream().sorted(Comparator.comparingInt($ -> WailaCommonRegistration.instance().priorities.getSortedList().indexOf((Object)$.id()))).toList())).sorted(Comparator.comparingInt(WailaClientRegistration.specialOrder()).thenComparing($ -> $.title().getString())).toList();
    }

    private static ToIntFunction<Category> specialOrder() {
        String core = class_1074.method_4662((String)OptionsList.Entry.makeKey("plugin_jade"), (Object[])new Object[0]);
        String debug = class_1074.method_4662((String)OptionsList.Entry.makeKey("plugin_jade.debug"), (Object[])new Object[0]);
        return category -> {
            String title = category.title().getString();
            if (core.equals(title)) {
                return -1;
            }
            if (debug.equals(title)) {
                return 1;
            }
            return 0;
        };
    }

    public void setServerConfig(Map<class_2960, Object> config) {
        for (ConfigEntry<?> entry : this.configEntries.values()) {
            entry.setSyncedValue(null);
        }
        config.forEach((key, value) -> {
            ConfigEntry<?> entry = this.getConfigEntry((class_2960)key);
            if (entry != null) {
                try {
                    value = entry.convertValue(value);
                    if (entry.isValidValue(value)) {
                        entry.setSyncedValue(value);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Jade.config().fixData();
    }

    public void loadComplete() {
        PriorityStore<class_2960, IJadeProvider> priorities = WailaCommonRegistration.instance().priorities;
        this.blockComponentProviders.loadComplete(priorities);
        this.blockIconProviders.loadComplete(priorities);
        this.entityComponentProviders.loadComplete(priorities);
        this.entityIconProviders.loadComplete(priorities);
        Stream.of(this.afterRenderCallback, this.beforeRenderCallback, this.rayTraceCallback, this.tooltipCollectedCallback, this.itemModNameCallback, this.beforeTooltipCollectCallback).forEach(CallbackContainer::sort);
    }

    @Override
    public void addAfterRenderCallback(int priority, JadeAfterRenderCallback callback) {
        Objects.requireNonNull(callback);
        this.afterRenderCallback.add(priority, callback);
    }

    @Override
    public void addBeforeRenderCallback(int priority, JadeBeforeRenderCallback callback) {
        Objects.requireNonNull(callback);
        this.beforeRenderCallback.add(priority, callback);
    }

    @Override
    public void addRayTraceCallback(int priority, JadeRayTraceCallback callback) {
        Objects.requireNonNull(callback);
        this.rayTraceCallback.add(priority, callback);
    }

    @Override
    public void addTooltipCollectedCallback(int priority, JadeTooltipCollectedCallback callback) {
        Objects.requireNonNull(callback);
        this.tooltipCollectedCallback.add(priority, callback);
    }

    @Override
    public void addItemModNameCallback(int priority, JadeItemModNameCallback callback) {
        Objects.requireNonNull(callback);
        this.itemModNameCallback.add(priority, callback);
    }

    @Override
    public void addBeforeTooltipCollectCallback(int priority, JadeBeforeTooltipCollectCallback callback) {
        Objects.requireNonNull(callback);
        this.beforeTooltipCollectCallback.add(priority, callback);
    }

    @Override
    public EmptyAccessor.Builder emptyAccessor() {
        class_310 mc = class_310.method_1551();
        return new EmptyAccessorImpl.Builder().level((class_1937)mc.field_1687).player((class_1657)mc.field_1724).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public BlockAccessor.Builder blockAccessor() {
        class_310 mc = class_310.method_1551();
        return new BlockAccessorImpl.Builder().level((class_1937)mc.field_1687).player((class_1657)mc.field_1724).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public EntityAccessor.Builder entityAccessor() {
        class_310 mc = class_310.method_1551();
        return new EntityAccessorImpl.Builder().level((class_1937)mc.field_1687).player((class_1657)mc.field_1724).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public void registerCustomEnchantPower(class_2248 block, CustomEnchantPower customEnchantPower) {
        this.customEnchantPowers.put(block, customEnchantPower);
    }

    @Override
    public class_437 createPluginConfigScreen(@Nullable class_437 parent, @Nullable class_2561 jumpToCategory) {
        Function<OptionsList, OptionsList.Entry> jumpTo = null;
        if (jumpToCategory != null) {
            String title = jumpToCategory.getString();
            jumpTo = options -> {
                for (OptionsList.Entry entry : options.method_25396()) {
                    OptionsList.Title e;
                    if (!(entry instanceof OptionsList.Title) || !(e = (OptionsList.Title)entry).getTitle().getString().equals(title)) continue;
                    return entry;
                }
                return null;
            };
        }
        return PluginsConfigScreen.createPluginConfigScreen(parent, jumpTo, false);
    }

    @Override
    public void registerItemStorageClient(IClientExtensionProvider<class_1799, ItemView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.itemStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerFluidStorageClient(IClientExtensionProvider<FluidView.Data, FluidView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.fluidStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerEnergyStorageClient(IClientExtensionProvider<EnergyView.Data, EnergyView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.energyStorageProviders.put(provider.getUid(), provider);
    }

    @Override
    public void registerProgressClient(IClientExtensionProvider<ProgressView.Data, ProgressView> provider) {
        Objects.requireNonNull(provider.getUid());
        this.progressProviders.put(provider.getUid(), provider);
    }

    @Override
    public boolean isServerConnected() {
        return ObjectDataCenter.serverConnected;
    }

    @Override
    public boolean isShowDetailsPressed() {
        return ClientProxy.isShowDetailsPressed();
    }

    @Override
    @Nullable
    public class_2487 getServerData() {
        return JadeClient.tickHandler().getData();
    }

    @Override
    public void setServerData(class_2487 tag) {
        JadeClient.tickHandler().setData(tag);
    }

    @Override
    public class_1799 getBlockCamouflage(class_1936 level, class_2338 pos) {
        return DatapackBlockManager.getFakeBlock(level, pos);
    }

    @Override
    public void markAsClientFeature(class_2960 uid) {
        this.clientFeatures.add(uid);
    }

    @Override
    public void markAsServerFeature(class_2960 uid) {
        this.clientFeatures.remove(uid);
    }

    @Override
    public boolean isClientFeature(class_2960 uid) {
        return this.clientFeatures.contains(uid);
    }

    @Override
    public <T extends Accessor<?>> void registerAccessorHandler(Class<T> clazz, AccessorClientHandler<T> handler) {
        this.accessorHandlers.put(clazz, handler);
    }

    @Override
    public AccessorClientHandler<Accessor<?>> getAccessorHandler(Class<? extends Accessor<?>> clazz) {
        return Objects.requireNonNull(this.accessorHandlers.get(clazz), () -> "No accessor handler for " + String.valueOf(clazz));
    }

    @Override
    public void addEntityVariantMapping(class_1299<?> entityType, @Nullable class_9331<?> variantType) {
        EntityVariantHelper.addVariantMapping(entityType, variantType);
    }

    @Override
    public void addVariantType(class_9331<?> type, boolean isVariant) {
        EntityVariantHelper.addVariantType(type, isVariant);
    }

    @Override
    public void reloadIgnoreLists() {
        class_634 connection = class_310.method_1551().method_1562();
        if (connection != null) {
            WailaCommonRegistration.instance().reloadOperations((class_7225.class_7874)connection.method_29091());
        }
    }

    @Override
    public boolean maybeLowVisionUser() {
        return ClientProxy.hasAccessibilityMod() || IWailaConfig.get().accessibility().shouldEnableTextToSpeech();
    }

    private /* synthetic */ void lambda$getConfigListView$2(boolean enableAccessibilityPlugins, Multimap categoryMap, class_2960 key, ConfigEntry entry) {
        class_2960 primaryKey;
        Collection components;
        if (this.configCategoryOverrides.containsKey((Object)key)) {
            return;
        }
        if (!enableAccessibilityPlugins && JadeIds.isAccess(key)) {
            return;
        }
        if (!IPluginConfig.isPrimaryKey(key) && !(components = this.configCategoryOverrides.get((Object)(primaryKey = IPluginConfig.getPrimaryKey(key)))).isEmpty()) {
            for (class_2561 component : components) {
                categoryMap.put((Object)component.getString(), (Object)entry);
            }
            return;
        }
        String namespace = key.method_12836();
        Optional<String> modName = ModIdentification.getModFullName(namespace);
        if (!"jade".equals(namespace) && modName.isPresent()) {
            categoryMap.put((Object)modName.get(), (Object)entry);
        } else {
            categoryMap.put((Object)class_1074.method_4662((String)OptionsList.Entry.makeKey("plugin_" + namespace), (Object[])new Object[0]), (Object)entry);
        }
    }

    private /* synthetic */ void lambda$getConfigListView$1(Multimap categoryMap, class_2960 key, class_2561 component) {
        categoryMap.put((Object)component.getString(), this.getConfigEntry(key));
    }

    public record Category(class_5250 title, List<ConfigEntry<?>> entries) {
    }
}

