/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.inventoryessentials.InventoryEssentials;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryEssentialsIgnores;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.client.CreativeInventoryControls;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.blay09.mods.inventoryessentials.client.ModKeyMappings;
import net.blay09.mods.inventoryessentials.client.ServerSupportedInventoryControls;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class InventoryEssentialsClient {
    private static final InventoryControls clientOnlyControls = new ClientOnlyInventoryControls();
    private static final InventoryControls creativeControls = new CreativeInventoryControls();
    private static final InventoryControls serverSupportedControls = new ServerSupportedInventoryControls();
    private static class_1735 lastDragHoverSlot;
    private static boolean hasDragClicked;

    public static void initialize() {
        ModKeyMappings.initialize();
        Balm.getEvents().onEvent(ScreenMouseEvent.Drag.Pre.class, InventoryEssentialsClient::onMouseDrag);
        Balm.getEvents().onEvent(ScreenMouseEvent.Release.Pre.class, InventoryEssentialsClient::onMouseRelease);
    }

    public static InventoryControls getInventoryControls(class_437 screen) {
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            return creativeControls;
        }
        return InventoryEssentials.isServerSideInstalled && !InventoryEssentialsConfig.getActive().forceClientImplementation ? serverSupportedControls : clientOnlyControls;
    }

    public static void onMouseRelease(ScreenMouseEvent.Release.Pre event) {
        class_437 class_4372 = event.getScreen();
        if (class_4372 instanceof class_465) {
            class_465 screen = (class_465)class_4372;
            class_1735 hoverSlot = ((AbstractContainerScreenAccessor)screen).getHoveredSlot();
            if (hoverSlot == null || InventoryEssentialsIgnores.shouldIgnoreScreen((class_437)screen) || InventoryEssentialsIgnores.shouldIgnoreSlot(screen, hoverSlot)) {
                return;
            }
            if (hasDragClicked) {
                event.setCanceled(true);
                hasDragClicked = false;
            }
        }
    }

    public static void onMouseDrag(ScreenMouseEvent.Drag.Pre event) {
        class_437 class_4372 = event.getScreen();
        if (class_4372 instanceof class_465) {
            class_1799 carriedStack;
            class_465 screen = (class_465)class_4372;
            class_1735 hoverSlot = ((AbstractContainerScreenAccessor)screen).getHoveredSlot();
            if (hoverSlot == null || InventoryEssentialsIgnores.shouldIgnoreScreen((class_437)screen) || InventoryEssentialsIgnores.shouldIgnoreSlot(screen, hoverSlot)) {
                return;
            }
            if (ModKeyMappings.keyDragTransfer.isActiveAndDown() && (event.getButton() == 0 || event.getButton() == 1)) {
                if (hoverSlot.method_7681() && hoverSlot != lastDragHoverSlot) {
                    InventoryControls controls = InventoryEssentialsClient.getInventoryControls((class_437)screen);
                    if (InventoryEssentialsConfig.getActive().enableShiftDrag) {
                        controls.dragTransfer(screen, hoverSlot);
                    }
                    lastDragHoverSlot = hoverSlot;
                }
                return;
            }
            if (InventoryEssentialsConfig.getActive().enableBundleDrag && (carriedStack = screen.method_17577().method_34255()).method_31573(class_3489.field_54294)) {
                if (hoverSlot != lastDragHoverSlot) {
                    if (event.getButton() == 0 && hoverSlot.method_7681() || event.getButton() == 1 && !hoverSlot.method_7681()) {
                        InventoryControls controls = InventoryEssentialsClient.getInventoryControls((class_437)screen);
                        controls.dragClick(screen, hoverSlot, event.getButton());
                        hasDragClicked = true;
                        ((AbstractContainerScreenAccessor)screen).setIsQuickCrafting(false);
                    }
                    lastDragHoverSlot = hoverSlot;
                }
                event.setCanceled(true);
                return;
            }
            lastDragHoverSlot = null;
        } else {
            lastDragHoverSlot = null;
        }
    }
}

