/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.impl;

import de.siphalor.amecs.api.KeyBindingUtils;
import de.siphalor.amecs.api.KeyModifier;
import de.siphalor.amecs.api.KeyModifiers;
import de.siphalor.amecs.api.PriorityKeyBinding;
import de.siphalor.amecs.impl.AmecsAPI;
import de.siphalor.amecs.impl.duck.IKeyBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public class KeyBindingManager {
    public static final Map<class_3675.class_306, List<class_304>> keysById = new HashMap<class_3675.class_306, List<class_304>>();
    public static final Map<class_3675.class_306, List<class_304>> priorityKeysById = new HashMap<class_3675.class_306, List<class_304>>();
    private static final List<class_304> pressedKeyBindings = new ArrayList<class_304>(10);

    private KeyBindingManager() {
    }

    private static boolean removeKeyBindingFromMap(Map<class_3675.class_306, List<class_304>> targetMap, class_304 keyBinding) {
        class_3675.class_306 keyCode = ((IKeyBinding)keyBinding).amecs$getBoundKey();
        List<class_304> keyBindings = targetMap.get(keyCode);
        if (keyBindings == null) {
            return false;
        }
        boolean removed = false;
        while (keyBindings.remove(keyBinding)) {
            removed = true;
        }
        return removed;
    }

    private static boolean addKeyBindingToListFromMap(Map<class_3675.class_306, List<class_304>> targetMap, class_304 keyBinding) {
        class_3675.class_306 keyCode = ((IKeyBinding)keyBinding).amecs$getBoundKey();
        List keyBindings = targetMap.computeIfAbsent(keyCode, k -> new ArrayList());
        if (keyBindings.contains(keyBinding)) {
            return false;
        }
        keyBindings.add(keyBinding);
        return true;
    }

    public static boolean register(class_304 keyBinding) {
        if (keyBinding instanceof PriorityKeyBinding) {
            return KeyBindingManager.addKeyBindingToListFromMap(priorityKeysById, keyBinding);
        }
        return KeyBindingManager.addKeyBindingToListFromMap(keysById, keyBinding);
    }

    public static Stream<class_304> getMatchingKeyBindings(class_3675.class_306 keyCode, boolean priority) {
        List<class_304> keyBindingList = (priority ? priorityKeysById : keysById).get(keyCode);
        if (keyBindingList == null) {
            return Stream.empty();
        }
        Stream<class_304> result = keyBindingList.stream().filter(KeyBindingManager::areExactModifiersPressed);
        List keyBindings = result.collect(Collectors.toList());
        if (keyBindings.isEmpty()) {
            return keyBindingList.stream().filter(keyBinding -> ((IKeyBinding)keyBinding).amecs$getKeyModifiers().isUnset());
        }
        return keyBindings.stream();
    }

    private static boolean areExactModifiersPressed(class_304 keyBinding) {
        return KeyBindingUtils.getBoundModifiers(keyBinding).equals(AmecsAPI.CURRENT_MODIFIERS);
    }

    public static void onKeyPressed(class_3675.class_306 keyCode) {
        KeyBindingManager.getMatchingKeyBindings(keyCode, false).forEach(keyBinding -> ((IKeyBinding)keyBinding).amecs$incrementTimesPressed());
    }

    private static Stream<class_304> getKeyBindingsFromMap(Map<class_3675.class_306, List<class_304>> keysById_map) {
        return keysById_map.values().stream().flatMap(Collection::stream);
    }

    private static void forEachKeyBinding(Consumer<class_304> consumer) {
        KeyBindingManager.getKeyBindingsFromMap(priorityKeysById).forEach(consumer);
        KeyBindingManager.getKeyBindingsFromMap(keysById).forEach(consumer);
    }

    private static void forEachKeyBindingWithKey(class_3675.class_306 key, Consumer<class_304> consumer) {
        KeyBindingManager.getMatchingKeyBindings(key, true).forEach(consumer);
        KeyBindingManager.getMatchingKeyBindings(key, false).forEach(consumer);
    }

    public static void updatePressedStates() {
        class_1041 windowHandle = class_310.method_1551().method_22683();
        KeyBindingManager.forEachKeyBinding(keyBinding -> {
            class_3675.class_306 key = ((IKeyBinding)keyBinding).amecs$getBoundKey();
            boolean pressed = !keyBinding.method_1415() && key.method_1442() == class_3675.class_307.field_1668 && class_3675.method_15987((class_1041)windowHandle, (int)key.method_1444());
            KeyBindingManager.setKeyBindingPressed(keyBinding, pressed);
        });
    }

    public static boolean unregister(class_304 keyBinding) {
        if (keyBinding == null) {
            return false;
        }
        boolean removed = false;
        removed |= KeyBindingManager.removeKeyBindingFromMap(keysById, keyBinding);
        return removed |= KeyBindingManager.removeKeyBindingFromMap(priorityKeysById, keyBinding);
    }

    public static void updateKeysByCode() {
        keysById.clear();
        priorityKeysById.clear();
        KeyBindingUtils.getIdToKeyBindingMap().values().forEach(KeyBindingManager::register);
    }

    public static void setKeyBindingPressed(class_304 keyBinding, boolean pressed) {
        if (pressed != keyBinding.method_1434()) {
            if (pressed) {
                pressedKeyBindings.add(keyBinding);
            } else {
                pressedKeyBindings.remove(keyBinding);
            }
        }
        keyBinding.method_23481(pressed);
    }

    public static void unpressAll() {
        KeyBindingUtils.getIdToKeyBindingMap().values().forEach(keyBinding -> ((IKeyBinding)keyBinding).amecs$reset());
    }

    public static boolean onKeyPressedPriority(class_3675.class_306 keyCode) {
        Optional<class_304> keyBindings = KeyBindingManager.getMatchingKeyBindings(keyCode, true).filter(keyBinding -> ((PriorityKeyBinding)keyBinding).onPressedPriority()).findFirst();
        return keyBindings.isPresent();
    }

    public static boolean onKeyReleasedPriority(class_3675.class_306 keyCode) {
        Optional<class_304> keyBindings = KeyBindingManager.getMatchingKeyBindings(keyCode, true).filter(keyBinding -> ((PriorityKeyBinding)keyBinding).onReleasedPriority()).findFirst();
        return keyBindings.isPresent();
    }

    public static void setKeyPressed(class_3675.class_306 keyCode, boolean pressed) {
        KeyModifier modifier = KeyModifier.fromKeyCode(keyCode.method_1444());
        AmecsAPI.CURRENT_MODIFIERS.set(modifier, pressed);
        KeyBindingManager.forEachKeyBindingWithKey(keyCode, keyBinding -> KeyBindingManager.setKeyBindingPressed(keyBinding, pressed));
        if (modifier != null && !pressed) {
            KeyBindingManager.handleReleasedModifier();
        }
    }

    private static void handleReleasedModifier() {
        pressedKeyBindings.removeIf(pressedKeyBinding -> {
            KeyModifiers boundModifiers = KeyBindingUtils.getBoundModifiers(pressedKeyBinding);
            if (!AmecsAPI.CURRENT_MODIFIERS.contains(boundModifiers)) {
                pressedKeyBinding.method_23481(false);
                return true;
            }
            return false;
        });
    }
}

