/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.transform;

import io.github.douira.glsl_transformer.ast.transform.PresentSourceLocation;
import io.github.douira.glsl_transformer.ast.transform.SourceLocation;

public class NumberedSourceLocation
extends PresentSourceLocation {
    public final int sourceNumber;

    public NumberedSourceLocation(int parsedLine, int line, int sourceNumber) {
        super(parsedLine, line);
        this.sourceNumber = sourceNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean needsPrint(int printedLines, PresentSourceLocation lastPrinted, int lastLocationPrintedLines) {
        if (lastPrinted == null) {
            return true;
        }
        if (printedLines + lastPrinted.line - lastLocationPrintedLines != this.line) return true;
        if (!(lastPrinted instanceof NumberedSourceLocation)) return true;
        NumberedSourceLocation lastNumbered = (NumberedSourceLocation)lastPrinted;
        if (this.sourceNumber != lastNumbered.sourceNumber) return true;
        return false;
    }

    @Override
    public SourceLocation createFromPrevious(int parsedLine) {
        return new NumberedSourceLocation(parsedLine, this.line, this.sourceNumber);
    }

    @Override
    public SourceLocation createFromPrevious(int parsedLine, int line) {
        return new NumberedSourceLocation(parsedLine, line, this.sourceNumber);
    }
}

