/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.print;

import io.github.douira.glsl_transformer.ast.print.DelegateTokenProcessor;
import io.github.douira.glsl_transformer.ast.print.TokenProcessor;
import io.github.douira.glsl_transformer.ast.print.token.LineDirectiveMarker;
import io.github.douira.glsl_transformer.ast.print.token.LiteralToken;
import io.github.douira.glsl_transformer.ast.print.token.PrintToken;
import io.github.douira.glsl_transformer.ast.transform.NamedSourceLocation;
import io.github.douira.glsl_transformer.ast.transform.NumberedSourceLocation;
import io.github.douira.glsl_transformer.ast.transform.PresentSourceLocation;

public class LineAnnotator
extends DelegateTokenProcessor {
    private int printedLines = 0;
    private PresentSourceLocation lastPrintedLocation;
    private int lastLocationPrintedLines = 0;
    private boolean lineEmpty = true;

    public LineAnnotator(TokenProcessor delegate) {
        super(delegate);
    }

    private void incrementLines() {
        ++this.printedLines;
    }

    @Override
    public void appendToken(PrintToken token) {
        if (token instanceof LineDirectiveMarker) {
            LineDirectiveMarker lineDirectiveMarker = (LineDirectiveMarker)token;
            PresentSourceLocation location = lineDirectiveMarker.location;
            if (!location.needsPrint(this.printedLines, this.lastPrintedLocation, this.lastLocationPrintedLines)) {
                return;
            }
            if (!this.lineEmpty) {
                super.appendToken(new LiteralToken("\n"));
                this.incrementLines();
            }
            super.appendToken(new LiteralToken("#line "));
            super.appendToken(new LiteralToken(Integer.toString(location.line)));
            if (location instanceof NumberedSourceLocation) {
                NumberedSourceLocation numbered = (NumberedSourceLocation)location;
                super.appendToken(new LiteralToken(" "));
                super.appendToken(new LiteralToken(Integer.toString(numbered.sourceNumber)));
            } else if (location instanceof NamedSourceLocation) {
                NamedSourceLocation named = (NamedSourceLocation)location;
                super.appendToken(new LiteralToken(" \""));
                super.appendToken(new LiteralToken(named.sourceName));
                super.appendToken(new LiteralToken("\""));
            }
            super.appendToken(new LiteralToken("\n"));
            this.incrementLines();
            this.lastPrintedLocation = location;
            this.lastLocationPrintedLines = this.printedLines;
        } else {
            if (token.endsWithNewline()) {
                this.lineEmpty = true;
                this.incrementLines();
            } else if (token.getContent() != null) {
                this.lineEmpty = false;
            }
            super.appendToken(token);
        }
    }
}

